/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.structure.resources;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.dom.resources.StyleItem;
import org.jetbrains.android.dom.structure.StructureUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceStructureViewBuilder
extends TreeBasedStructureViewBuilder {
    private final DomFileElement<Resources> myResources;

    public ResourceStructureViewBuilder(@NotNull DomFileElement<Resources> resources) {
        this.myResources = resources;
    }

    @NotNull
    public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
        return new StructureViewModelBase((PsiFile)this.myResources.getFile(), (StructureViewTreeElement)new ResourcesRoot(this.myResources));
    }

    private static class ResourcesRoot
    extends PsiTreeElementBase<PsiElement> {
        private final DomFileElement<Resources> myResources;

        ResourcesRoot(@NotNull DomFileElement<Resources> resources) {
            super((PsiElement)resources.getXmlElement());
            this.myResources = resources;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            if (!this.myResources.isValid()) {
                return Collections.emptySet();
            }
            final ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>();
            StructureUtils.acceptChildrenInOrder(this.myResources.getRootElement(), new DomElementVisitor(){

                public void visitDomElement(DomElement element) {
                }

                public void visitResourceElement(ResourceElement element) {
                    ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(element.getXmlTag());
                    String name2 = (String)element.getName().getValue();
                    XmlElement xmlElement = element.getXmlElement();
                    if (name2 != null && type != null && xmlElement != null) {
                        result2.add(new Resource(element, name2, type));
                    }
                }

                public void visitAttr(Attr element) {
                    ResourceReference resourceReference = (ResourceReference)element.getName().getValue();
                    XmlElement xmlElement = element.getXmlElement();
                    if (resourceReference != null && xmlElement != null) {
                        result2.add(new Resource(element, resourceReference.getName(), resourceReference.getResourceType()));
                    }
                }
            });
            return result2;
        }

        @NotNull
        public String getPresentableText() {
            return String.format("Resources file '%s'", this.myResources.getFile().getName());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getPresentableText());
            builder.append('\n');
            for (StructureViewTreeElement child : this.getChildrenBase()) {
                builder.append("  ").append(child.toString()).append('\n');
                if (!(child instanceof Resource)) continue;
                for (StructureViewTreeElement grandChild : ((Resource)child).getChildrenBase()) {
                    builder.append("    ").append(grandChild.toString()).append('\n');
                }
            }
            return builder.toString();
        }
    }

    private static class Resource
    extends PsiTreeElementBase<PsiElement> {
        private final String myName;
        private final ResourceType myResourceType;
        private final DomElement myElement;

        protected Resource(@NotNull DomElement element, @NotNull String name2, @NotNull ResourceType resourceType) {
            super((PsiElement)element.getXmlTag());
            this.myElement = element;
            this.myName = name2;
            this.myResourceType = resourceType;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            final ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>();
            DomElementVisitor visitor2 = new DomElementVisitor(){

                public void visitStyleItem(StyleItem element) {
                    ResourceReference resourceReference = (ResourceReference)element.getName().getValue();
                    if (resourceReference != null) {
                        result2.add(new Resource(element, resourceReference.getName(), ResourceType.STYLE_ITEM));
                    }
                }

                public void visitAttr(Attr element) {
                    ResourceReference resourceReference = (ResourceReference)element.getName().getValue();
                    XmlElement xmlElement = element.getXmlElement();
                    if (resourceReference != null && xmlElement != null) {
                        result2.add(new Resource(element, resourceReference.getName(), resourceReference.getResourceType()));
                    }
                }

                public void visitDomElement(DomElement element) {
                }
            };
            StructureUtils.acceptChildrenInOrder(this.myElement, visitor2);
            return result2;
        }

        @Nullable
        public String getPresentableText() {
            return this.myResourceType.getDisplayName() + " - " + this.myName;
        }

        public String toString() {
            return this.getPresentableText();
        }
    }
}

