/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.inspections;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.imports.MavenClassRegistryManager;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.dom.inspections.AndroidUnresolvableTagInspectionKt;
import org.jetbrains.android.dom.inspections.MavenClassResolverUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J\b\u0010\u0006\u001a\u00020\u0005H\u0017J\b\u0010\u0007\u001a\u00020\u0005H\u0016J-\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/android/dom/inspections/AndroidUnresolvableTagInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "getGroupDisplayName", "", "getDisplayName", "getShortName", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "isRelevantFile", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "Lcom/intellij/psi/xml/XmlFile;", "MyVisitor", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAndroidUnresolvableTagInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidUnresolvableTagInspection.kt\norg/jetbrains/android/dom/inspections/AndroidUnresolvableTagInspection\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,133:1\n37#2:134\n36#2,3:135\n*S KotlinDebug\n*F\n+ 1 AndroidUnresolvableTagInspection.kt\norg/jetbrains/android/dom/inspections/AndroidUnresolvableTagInspection\n*L\n60#1:134\n60#1:135,3\n*E\n"})
public final class AndroidUnresolvableTagInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = AndroidBundle.message("android.inspections.group.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AndroidBundle.message("android.inspections.unresolvable.tag", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getShortName() {
        return "AndroidUnresolvableTag";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!(file instanceof XmlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)((PsiElement)file));
        if (androidFacet == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet facet = androidFacet;
        if (this.isRelevantFile(facet, (XmlFile)file)) {
            MyVisitor visitor2 = new MyVisitor(manager, isOnTheFly, facet);
            file.accept((PsiElementVisitor)visitor2);
            Collection $this$toTypedArray$iv = visitor2.getMyResult();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new ProblemDescriptor[0]);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private final boolean isRelevantFile(AndroidFacet facet, XmlFile file) {
        ResourceFolderType resourceType = ModuleResourceManagers.getInstance(facet).getLocalResourceManager().getFileResourceFolderType((PsiFile)file);
        return resourceType != null ? resourceType == ResourceFolderType.LAYOUT || resourceType == ResourceFolderType.MENU : false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0014*\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/android/dom/inspections/AndroidUnresolvableTagInspection$MyVisitor;", "Lcom/intellij/psi/XmlRecursiveElementVisitor;", "myInspectionManager", "Lcom/intellij/codeInspection/InspectionManager;", "myOnTheFly", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "<init>", "(Lcom/intellij/codeInspection/InspectionManager;ZLorg/jetbrains/android/facet/AndroidFacet;)V", "myResult", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getMyResult", "()Ljava/util/List;", "visitXmlTag", "", "tag", "Lcom/intellij/psi/xml/XmlTag;", "getTagNameRange", "Lcom/intellij/psi/PsiElement;", "findChildToken", "targetType", "Lcom/intellij/psi/tree/IElementType;", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nAndroidUnresolvableTagInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidUnresolvableTagInspection.kt\norg/jetbrains/android/dom/inspections/AndroidUnresolvableTagInspection$MyVisitor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,133:1\n37#2:134\n36#2,3:135\n*S KotlinDebug\n*F\n+ 1 AndroidUnresolvableTagInspection.kt\norg/jetbrains/android/dom/inspections/AndroidUnresolvableTagInspection$MyVisitor\n*L\n108#1:134\n108#1:135,3\n*E\n"})
    private static final class MyVisitor
    extends XmlRecursiveElementVisitor {
        @NotNull
        private final InspectionManager myInspectionManager;
        private final boolean myOnTheFly;
        @NotNull
        private final AndroidFacet facet;
        @NotNull
        private final List<ProblemDescriptor> myResult;

        public MyVisitor(@NotNull InspectionManager myInspectionManager, boolean myOnTheFly, @NotNull AndroidFacet facet) {
            Intrinsics.checkNotNullParameter((Object)myInspectionManager, (String)"myInspectionManager");
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            this.myInspectionManager = myInspectionManager;
            this.myOnTheFly = myOnTheFly;
            this.facet = facet;
            this.myResult = new ArrayList();
        }

        @NotNull
        public final List<ProblemDescriptor> getMyResult() {
            return this.myResult;
        }

        /*
         * Unable to fully structure code
         */
        public void visitXmlTag(@NotNull XmlTag tag) {
            block4: {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                super.visitXmlTag(tag);
                v0 = tag.getNamespace();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getNamespace(...)");
                if (((CharSequence)v0).length() > 0) {
                    return;
                }
                v1 = tag.getReferences();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getReferences(...)");
                v2 = (PsiReference)ArraysKt.lastOrNull((Object[])v1);
                if (v2 == null) {
                    return;
                }
                reference = v2;
                if (reference.resolve() != null || AndroidUnresolvableTagInspectionKt.access$getBuiltinTags$p().contains(tag.getName())) break block4;
                v3 = tag.getName();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getName(...)");
                className = v3;
                var5_4 = MavenClassRegistryManager.Companion.getInstance().tryGetMavenClassRegistry();
                if (var5_4 == null) ** GOTO lbl-1000
                v4 = tag.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getProject(...)");
                v5 = this.facet.getModule();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getModule(...)");
                v6 = tag.getContainingFile();
                var6_5 = MavenClassResolverUtils.collectFixesFromMavenClassRegistry(var5_4, className, v4, v5, (FileType)(v6 != null ? v6.getFileType() : null));
                if (var6_5 != null) {
                    v7 = var6_5;
                } else lbl-1000:
                // 2 sources

                {
                    v7 = CollectionsKt.emptyList();
                }
                fixes = v7;
                v8 = this.getTagNameRange(tag);
                if (v8 == null) break block4;
                it = v8;
                $i$a$-let-AndroidUnresolvableTagInspection$MyVisitor$visitXmlTag$1 = false;
                var9_9 = new Object[]{className};
                $this$toTypedArray$iv = fixes;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                v9 = this.myInspectionManager.createProblemDescriptor(it, AndroidBundle.message("element.cannot.resolve", var9_9), this.myOnTheFly, thisCollection$iv.toArray(new LocalQuickFix[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"createProblemDescriptor(...)");
                this.myResult.add(v9);
            }
        }

        private final PsiElement getTagNameRange(XmlTag tag) {
            PsiElement psiElement = tag.getFirstChild();
            if (psiElement == null || (psiElement = psiElement.getNextSibling()) == null) {
                return null;
            }
            PsiElement range = psiElement;
            PsiElement psiElement2 = this.findChildToken(range, XmlTokenType.XML_NAME);
            if (psiElement2 == null) {
                psiElement2 = range;
            }
            return psiElement2;
        }

        private final PsiElement findChildToken(PsiElement $this$findChildToken, IElementType targetType) {
            PsiElement curr;
            for (curr = $this$findChildToken.getFirstChild(); !(curr == null || curr instanceof XmlToken && Intrinsics.areEqual((Object)((XmlToken)curr).getTokenType(), (Object)targetType)); curr = curr.getNextSibling()) {
            }
            return curr;
        }
    }
}

