/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticEnumConverter
extends ResolvingConverter<String> {
    private final Set<String> myValues = new HashSet<String>();
    private boolean myContainsAllValues = true;

    public StaticEnumConverter(String ... values) {
        Collections.addAll(this.myValues, values);
    }

    public StaticEnumConverter(Collection<String> values) {
        this.myValues.addAll(values);
    }

    @NotNull
    public Collection<String> getVariants(@NotNull ConvertContext context) {
        return Collections.unmodifiableCollection(this.myValues);
    }

    public String fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
        if (this.myContainsAllValues) {
            return this.myValues.contains(s) ? s : null;
        }
        return s;
    }

    @NotNull
    public StaticEnumConverter setContainsAllValues(boolean flag) {
        this.myContainsAllValues = flag;
        return this;
    }

    public String toString() {
        return "StaticEnumConverter " + this.myValues.toString();
    }

    public String toString(@Nullable String s, @NotNull ConvertContext context) {
        return s;
    }
}

