/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.converters.CreateMissingClassQuickFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000e\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000fH\u0016J\r\u0010\u0010\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u0018\u0010\u000b\u001a\f0\u0005\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/android/dom/converters/CreateMissingKotlinClassQuickFix;", "Lorg/jetbrains/android/dom/converters/CreateMissingClassQuickFix;", "destinationPackage", "Lcom/intellij/psi/PsiPackage;", "className", "", "module", "Lcom/intellij/openapi/module/Module;", "baseClassFqName", "<init>", "(Lcom/intellij/psi/PsiPackage;Ljava/lang/String;Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "packageQualifiedName", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "Lorg/jetbrains/annotations/Nls;", "getFamilyName", "createClass", "Lcom/intellij/openapi/vfs/VirtualFile;", "directory", "Lcom/intellij/psi/PsiDirectory;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.core"})
public final class CreateMissingKotlinClassQuickFix
extends CreateMissingClassQuickFix {
    @NotNull
    private final String packageQualifiedName;

    public CreateMissingKotlinClassQuickFix(@NotNull PsiPackage destinationPackage, @NotNull String className, @NotNull Module module, @Nullable String baseClassFqName) {
        Intrinsics.checkNotNullParameter((Object)destinationPackage, (String)"destinationPackage");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super(destinationPackage, className, module, baseClassFqName, null);
        String string = destinationPackage.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedName(...)");
        this.packageQualifiedName = string;
    }

    @NotNull
    public String getName() {
        return "Create Kotlin class '" + this.getClassName() + "'";
    }

    @NotNull
    public String getFamilyName() {
        return "Create Kotlin class";
    }

    @Override
    @NotNull
    protected VirtualFile createClass(@NotNull PsiDirectory directory, @NotNull Project project) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String fileName = this.getClassName() + ".kt";
        StringBuilder $this$createClass_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createClass_u24lambda_u240.append("package " + this.packageQualifiedName).append('\n');
        $this$createClass_u24lambda_u240.append('\n');
        if (this.getBaseClassFqName() != null) {
            String baseClassShortName = StringsKt.substringAfterLast$default((String)this.getBaseClassFqName(), (char)'.', null, (int)2, null);
            $this$createClass_u24lambda_u240.append("import " + this.getBaseClassFqName()).append('\n');
            $this$createClass_u24lambda_u240.append('\n');
            v0 = $this$createClass_u24lambda_u240.append("class " + this.getClassName() + " : " + baseClassShortName + "()");
        } else {
            v0 = $this$createClass_u24lambda_u240.append("class " + this.getClassName());
        }
        $this$createClass_u24lambda_u240.append(" {\n\n}").append('\n');
        String fileText = stringBuilder.toString();
        KtFile file = new KtPsiFactory(project, false, 2, null).createPhysicalFile(fileName, fileText);
        directory.add((PsiElement)file);
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return virtualFile;
    }
}

