/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.ScopeType;
import com.android.tools.idea.psi.TagToClassMapper;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.migration.MigrationClassImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.AndroidXmlReferenceProviderKt;
import org.jetbrains.android.dom.drawable.CustomDrawableDomElement;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.layout.View;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.PreferenceElement;
import org.jetbrains.android.facet.AndroidClassesForXmlUtilKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.TagFromClassDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ,\u0010\f\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/android/dom/AndroidXmlReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "getClassFilter", "Lkotlin/Function2;", "", "Lcom/intellij/psi/PsiClass;", "", "baseClassQName", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "MyClassOrPackageReference", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAndroidXmlReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidXmlReferenceProvider.kt\norg/jetbrains/android/dom/AndroidXmlReferenceProvider\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,257:1\n37#2:258\n36#2,3:259\n*S KotlinDebug\n*F\n+ 1 AndroidXmlReferenceProvider.kt\norg/jetbrains/android/dom/AndroidXmlReferenceProvider\n*L\n66#1:258\n66#1:259,3\n*E\n"})
public final class AndroidXmlReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        ASTNode closingTagName;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(element instanceof XmlTag)) {
            return new PsiReference[0];
        }
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)element);
        if (androidFacet == null) {
            return new PsiReference[0];
        }
        AndroidFacet facet = androidFacet;
        String string = AndroidXmlReferenceProvider.Companion.computeBaseClass((XmlTag)element);
        if (string == null) {
            return new PsiReference[0];
        }
        String baseClassQName = string;
        Function2 function2 = this.getClassFilter(baseClassQName, facet);
        if (function2 == null) {
            function2 = AndroidXmlReferenceProvider::getReferencesByElement$lambda$0;
        }
        Function2 classFilter = function2;
        List result2 = new ArrayList();
        ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(element.getNode());
        if (startTagName != null) {
            AndroidXmlReferenceProvider.Companion.addReferences((XmlTag)element, startTagName, result2, facet, baseClassQName, (Function2<? super String, ? super PsiClass, Boolean>)classFilter, true);
        }
        if ((closingTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(element.getNode())) != null) {
            AndroidXmlReferenceProvider.Companion.addReferences((XmlTag)element, closingTagName, result2, facet, baseClassQName, (Function2<? super String, ? super PsiClass, Boolean>)classFilter, false);
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiReference[0]);
    }

    private final Function2<String, PsiClass, Boolean> getClassFilter(String baseClassQName, AndroidFacet facet) {
        if (Intrinsics.areEqual((Object)baseClassQName, (Object)"android.graphics.drawable.Drawable")) {
            String string = AndroidManifestIndexQueryUtils.queryPackageNameFromManifestIndex(facet);
            if (string == null) {
                return AndroidXmlReferenceProvider::getClassFilter$lambda$1;
            }
            String packageName = string;
            return (arg_0, arg_1) -> AndroidXmlReferenceProvider.getClassFilter$lambda$2(packageName, arg_0, arg_1);
        }
        return null;
    }

    private static final boolean getReferencesByElement$lambda$0(String string, PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"<unused var>");
        return true;
    }

    private static final boolean getClassFilter$lambda$1(String string, PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"<unused var>");
        return false;
    }

    private static final boolean getClassFilter$lambda$2(String $packageName, String string, PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        String string2 = psiClass.getQualifiedName();
        return string2 != null ? StringsKt.startsWith$default((String)string2, (String)$packageName, (boolean)false, (int)2, null) : false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JX\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/android/dom/AndroidXmlReferenceProvider$Companion;", "", "<init>", "()V", "addReferences", "", "tag", "Lcom/intellij/psi/xml/XmlTag;", "nameElement", "Lcom/intellij/lang/ASTNode;", "result", "", "Lcom/intellij/psi/PsiReference;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "baseClassQName", "", "classFilter", "Lkotlin/Function2;", "Lcom/intellij/psi/PsiClass;", "", "startTag", "computeBaseClass", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        private final void addReferences(XmlTag tag, ASTNode nameElement, List<PsiReference> result2, AndroidFacet facet, String baseClassQName, Function2<? super String, ? super PsiClass, Boolean> classFilter, boolean startTag) {
            String string = nameElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String text2 = string;
            String[] stringArray = new String[]{"."};
            List nameParts = StringsKt.split$default((CharSequence)text2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            int offset = 0;
            for (String name2 : nameParts) {
                if (((CharSequence)name2).length() > 0) {
                    TextRange range = new TextRange((offset += name2.length()) - name2.length(), offset);
                    result2.add((PsiReference)new MyClassOrPackageReference(tag, nameElement, range, facet, baseClassQName, classFilter, startTag));
                }
                ++offset;
            }
        }

        private final String computeBaseClass(XmlTag tag) {
            String string;
            DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
            if (domElement instanceof LayoutViewElement && !(domElement instanceof View)) {
                string = "android.view.View";
            } else if (domElement instanceof PreferenceElement) {
                AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)((PsiElement)tag));
                if (androidFacet == null) {
                    return null;
                }
                AndroidFacet facet = androidFacet;
                string = AndroidXmlResourcesUtil.PreferenceSource.Companion.getPreferencesSource(tag, facet).getQualifiedBaseClass();
            } else {
                string = domElement instanceof CustomDrawableDomElement ? "android.graphics.drawable.Drawable" : null;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001BQ\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0002H\u0002J\u0013\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u0002H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010\u00022\u0006\u0010%\u001a\u00020\fH\u0016J\b\u0010&\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lorg/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "myNameElement", "Lcom/intellij/lang/ASTNode;", "myRangeInNameElement", "Lcom/intellij/openapi/util/TextRange;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "myBaseClassQName", "", "classFilter", "Lkotlin/Function2;", "Lcom/intellij/psi/PsiClass;", "", "myStartTag", "<init>", "(Lcom/intellij/psi/xml/XmlTag;Lcom/intellij/lang/ASTNode;Lcom/intellij/openapi/util/TextRange;Lorg/jetbrains/android/facet/AndroidFacet;Ljava/lang/String;Lkotlin/jvm/functions/Function2;Z)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "packagePrefix", "isParentContainer", "()Z", "isParentContainer$delegate", "Lkotlin/Lazy;", "resolve", "resolveInner", "getVariants", "", "", "()[Ljava/lang/Object;", "bindToElement", "element", "handleElementRename", "newElementName", "getRangeInElement", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nAndroidXmlReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidXmlReferenceProvider.kt\norg/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,257:1\n1#2:258\n536#3:259\n521#3,6:260\n536#3:266\n521#3,6:267\n126#4:273\n153#4,3:274\n37#5:277\n36#5,3:278\n*S KotlinDebug\n*F\n+ 1 AndroidXmlReferenceProvider.kt\norg/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference\n*L\n132#1:259\n132#1:260,6\n140#1:266\n140#1:267,6\n141#1:273\n141#1:274,3\n144#1:277\n144#1:278,3\n*E\n"})
    private static final class MyClassOrPackageReference
    extends PsiReferenceBase<PsiElement> {
        @NotNull
        private final ASTNode myNameElement;
        @NotNull
        private final TextRange myRangeInNameElement;
        @NotNull
        private final AndroidFacet facet;
        @NotNull
        private final String myBaseClassQName;
        @NotNull
        private final Function2<String, PsiClass, Boolean> classFilter;
        private final boolean myStartTag;
        @NotNull
        private final Project project;
        @NotNull
        private final String packagePrefix;
        @NotNull
        private final Lazy isParentContainer$delegate;

        public MyClassOrPackageReference(@NotNull XmlTag tag, @NotNull ASTNode myNameElement, @NotNull TextRange myRangeInNameElement, @NotNull AndroidFacet facet, @NotNull String myBaseClassQName, @NotNull Function2<? super String, ? super PsiClass, Boolean> classFilter, boolean myStartTag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)myNameElement, (String)"myNameElement");
            Intrinsics.checkNotNullParameter((Object)myRangeInNameElement, (String)"myRangeInNameElement");
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            Intrinsics.checkNotNullParameter((Object)myBaseClassQName, (String)"myBaseClassQName");
            Intrinsics.checkNotNullParameter(classFilter, (String)"classFilter");
            super((PsiElement)tag, true);
            this.myNameElement = myNameElement;
            this.myRangeInNameElement = myRangeInNameElement;
            this.facet = facet;
            this.myBaseClassQName = myBaseClassQName;
            this.classFilter = classFilter;
            this.myStartTag = myStartTag;
            Project project = tag.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.project = project;
            String string = this.myNameElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string;
            int n = 0;
            int n2 = this.myRangeInNameElement.getStartOffset();
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            this.packagePrefix = string3;
            this.isParentContainer$delegate = LazyKt.lazy(() -> MyClassOrPackageReference.isParentContainer_delegate$lambda$0(tag));
        }

        private final boolean isParentContainer() {
            Lazy lazy = this.isParentContainer$delegate;
            return (Boolean)lazy.getValue();
        }

        @Nullable
        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.project).resolveWithCaching((PsiReference)this, (arg_0, arg_1) -> MyClassOrPackageReference.resolve$lambda$1(this, arg_0, arg_1), false, false);
        }

        private final PsiElement resolveInner() {
            PsiPackage psiPackage;
            int end = this.myRangeInNameElement.getEndOffset();
            String string = this.myNameElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string;
            int n = 0;
            String string3 = string2.substring(n, end);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String value2 = string3;
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.project);
            PsiClass psiClass = AndroidClassesForXmlUtilKt.findClassValidInXMLByName(this.facet, value2, this.myBaseClassQName);
            PsiElement psiElement = psiClass instanceof PsiElement ? (PsiElement)psiClass : null;
            if (psiElement == null && (psiElement = (psiPackage = facade.findPackage(value2)) instanceof PsiElement ? (PsiElement)psiPackage : null) == null) {
                Module module = this.facet.getModule();
                Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
                PsiPackage it = psiPackage = facade.findClass(value2, ProjectSystemUtil.getModuleSystem(module).getResolveScope(ScopeType.MAIN));
                boolean bl = false;
                psiElement = (PsiElement)(it instanceof MigrationClassImpl ? psiPackage : null);
            }
            return psiElement;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Object[] getVariants() {
            void $this$mapTo$iv$iv;
            PsiClass psiClass;
            String name2;
            Map.Entry entry;
            Map.Entry element$iv$iv;
            Map $this$filterTo$iv$iv;
            if (!this.isParentContainer()) {
                return new Object[0];
            }
            if (!this.myStartTag) {
                return new Object[0];
            }
            int apiLevel = StudioAndroidModuleInfo.getInstance(this.facet).getModuleMinApi();
            Map map2 = TagToClassMapper.getInstance(this.facet.getModule()).getClassMap(this.myBaseClassQName);
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getClassMap(...)");
            Map $this$filter$iv = map2;
            boolean $i$f$filter = false;
            Map map3 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                boolean bl;
                entry = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                name2 = (String)entry.getKey();
                psiClass = (PsiClass)entry.getValue();
                if (((CharSequence)this.packagePrefix).length() == 0 && Intrinsics.areEqual((Object)name2, (Object)psiClass.getQualifiedName())) {
                    String string = psiClass.getQualifiedName();
                    Intrinsics.checkNotNull((Object)string);
                    Intrinsics.checkNotNull((Object)psiClass);
                    bl = IdeResourcesUtil.isClassPackageNeeded(string, psiClass, apiLevel, this.myBaseClassQName);
                } else {
                    Intrinsics.checkNotNull((Object)name2);
                    bl = StringsKt.startsWith$default((String)name2, (String)this.packagePrefix, (boolean)false, (int)2, null);
                }
                if (!bl) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                entry = element$iv$iv = iterator2.next();
                boolean bl = false;
                name2 = (String)entry.getKey();
                psiClass = (PsiClass)entry.getValue();
                Intrinsics.checkNotNull((Object)name2);
                Intrinsics.checkNotNull((Object)psiClass);
                if (!((Boolean)this.classFilter.invoke((Object)name2, (Object)psiClass)).booleanValue()) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$map$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                entry = item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl = false;
                name2 = (String)entry.getKey();
                psiClass = (PsiClass)entry.getValue();
                Intrinsics.checkNotNull((Object)name2);
                String string = StringsKt.removePrefix((String)name2, (CharSequence)this.packagePrefix);
                Intrinsics.checkNotNull((Object)psiClass);
                object.add(AndroidXmlReferenceProviderKt.createClassAsTagXmlElement(string, psiClass));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Object[0]);
        }

        @NotNull
        public PsiElement bindToElement(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String newName = ((PsiQualifiedNamedElement)element).getQualifiedName();
            TextRange range = new TextRange(0, this.myRangeInNameElement.getEndOffset());
            PsiElement psiElement = ElementManipulators.handleContentChange((PsiElement)this.myNameElement.getPsi(), (TextRange)range, (String)newName);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"handleContentChange(...)");
            return psiElement;
        }

        @Nullable
        public PsiElement handleElementRename(@NotNull String newElementName) {
            Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
            return ElementManipulators.handleContentChange((PsiElement)this.myNameElement.getPsi(), (TextRange)this.myRangeInNameElement, (String)newElementName);
        }

        @NotNull
        public TextRange getRangeInElement() {
            int parentOffset = this.myNameElement.getStartOffsetInParent();
            return new TextRange(parentOffset + this.myRangeInNameElement.getStartOffset(), parentOffset + this.myRangeInNameElement.getEndOffset());
        }

        private static final boolean isParentContainer_delegate$lambda$0(XmlTag $tag) {
            PsiElement psiElement = $tag.getParent();
            XmlTag xmlTag = psiElement instanceof XmlTag ? (XmlTag)psiElement : null;
            XmlElementDescriptor xmlElementDescriptor = xmlTag != null ? xmlTag.getDescriptor() : null;
            TagFromClassDescriptor tagFromClassDescriptor = xmlElementDescriptor instanceof TagFromClassDescriptor ? (TagFromClassDescriptor)xmlElementDescriptor : null;
            if (tagFromClassDescriptor == null) {
                return true;
            }
            TagFromClassDescriptor parentTagFromClassDescriptor = tagFromClassDescriptor;
            return parentTagFromClassDescriptor.isContainer();
        }

        private static final PsiElement resolve$lambda$1(MyClassOrPackageReference this$0, MyClassOrPackageReference myClassOrPackageReference, boolean bl) {
            Intrinsics.checkNotNullParameter((Object)((Object)myClassOrPackageReference), (String)"<unused var>");
            return this$0.resolveInner();
        }
    }
}

