/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.CommonBundle;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.Border;
import org.jetbrains.android.exportSignedPackage.NewKeyForm;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.SaveFileListener;
import org.jetbrains.annotations.NotNull;

public class NewKeyStoreDialog
extends DialogWrapper {
    private JPanel myNewKeyPanel;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myKeyStorePathField;
    private JPasswordField myPasswordField;
    private JPasswordField myConfirmedPassword;
    private final NewKeyForm myNewKeyForm;
    private final Project myProject;

    public NewKeyStoreDialog(@NotNull Project project, @NotNull String defaultKeyStorePath) {
        super(project);
        this.setupUI();
        this.myProject = project;
        this.myKeyStorePathField.setText(defaultKeyStorePath);
        this.setTitle("New Key Store");
        this.myNewKeyForm = new MyNewKeyForm();
        this.myNewKeyPanel.add((Component)this.myNewKeyForm.getContentPanel(), "Center");
        this.myKeyStorePathField.addActionListener((ActionListener)new SaveFileListener(this.myPanel, this.myKeyStorePathField, AndroidBundle.message("android.extract.package.choose.keystore.title", new Object[0]), "jks"){

            @Override
            protected String getDefaultLocation() {
                return NewKeyStoreDialog.this.getKeyStorePath();
            }
        });
        this.init();
    }

    protected void init() {
        super.init();
        this.myPasswordField.setName("myPasswordField");
        this.myConfirmedPassword.setName("myConfirmedPassword");
        this.myNewKeyForm.init();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myKeyStorePathField;
    }

    protected void doOKAction() {
        if (this.getKeyStorePath().isEmpty()) {
            Messages.showErrorDialog((Component)this.myPanel, (String)"Specify key store path", (String)CommonBundle.getErrorTitle());
            return;
        }
        try {
            AndroidUtils.checkNewPassword(this.myPasswordField, this.myConfirmedPassword);
            this.myNewKeyForm.createKey();
        }
        catch (CommitStepException e) {
            Messages.showErrorDialog((Component)this.myPanel, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
            return;
        }
        super.doOKAction();
    }

    @NotNull
    public String getKeyStorePath() {
        return this.myKeyStorePathField.getText().trim();
    }

    @NotNull
    public char[] getKeyStorePassword() {
        return this.myPasswordField.getPassword();
    }

    @NotNull
    public String getKeyAlias() {
        return this.myNewKeyForm.getKeyAlias();
    }

    @NotNull
    public char[] getKeyPassword() {
        return this.myNewKeyForm.getKeyPassword();
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Key store path:");
        jBLabel1.setDisplayedMnemonic('K');
        jBLabel1.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.myKeyStorePathField = new TextFieldWithBrowseButton();
        this.myPanel.add((Component)this.myKeyStorePathField, new GridConstraints(0, 1, 1, 3, 0, 1, 4, 0, null, null, null, 0, false));
        this.myNewKeyPanel = new JPanel();
        this.myNewKeyPanel.setLayout(new BorderLayout(0, 0));
        this.myNewKeyPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        this.myPanel.add((Component)this.myNewKeyPanel, new GridConstraints(2, 0, 1, 4, 0, 3, 3, 3, null, null, null, 0, false));
        this.myNewKeyPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Key", (int)0, (int)0, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Password:");
        jBLabel2.setDisplayedMnemonic('P');
        jBLabel2.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myPasswordField = new JPasswordField();
        this.myPanel.add((Component)this.myPasswordField, new GridConstraints(1, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("Confirm:");
        label1.setDisplayedMnemonic('N');
        label1.setDisplayedMnemonicIndex(2);
        this.myPanel.add((Component)label1, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myConfirmedPassword = new JPasswordField();
        this.myPanel.add((Component)this.myConfirmedPassword, new GridConstraints(1, 3, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        jBLabel1.setLabelFor((Component)this.myKeyStorePathField);
        jBLabel2.setLabelFor((Component)this.myPasswordField);
        label1.setLabelFor(this.myConfirmedPassword);
    }

    private class MyNewKeyForm
    extends NewKeyForm {
        private MyNewKeyForm() {
        }

        @Override
        protected List<String> getExistingKeyAliasList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        protected Project getProject() {
            return NewKeyStoreDialog.this.myProject;
        }

        @Override
        @NotNull
        protected char[] getKeyStorePassword() {
            return NewKeyStoreDialog.this.getKeyStorePassword();
        }

        @Override
        @NotNull
        protected String getKeyStoreLocation() {
            return NewKeyStoreDialog.this.getKeyStorePath();
        }
    }
}

