/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.google.common.collect.ImmutableSet;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidLightInnerClassBase
extends AndroidLightClassBase {
    @NotNull
    private final AndroidLightClassBase myContainingClass;
    @NotNull
    protected final String myName;

    protected AndroidLightInnerClassBase(@NotNull AndroidLightClassBase context, @NotNull String name2) {
        super(context, (Iterable<String>)ImmutableSet.of((Object)"public", (Object)"static", (Object)"final"));
        this.myContainingClass = context;
        this.myName = name2;
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot add elements to R class");
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        return this.myContainingClass.add(element);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        return this.myContainingClass.addBefore(element, anchor);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        return this.myContainingClass.addAfter(element, anchor);
    }

    public String getQualifiedName() {
        return this.myContainingClass.getQualifiedName() + "." + this.myName;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return this.myContainingClass;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public PsiElement getParent() {
        return this.myContainingClass;
    }
}

