/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import java.io.File;
import org.jetbrains.android.actions.CreateResourceActionBase;
import org.jetbrains.android.actions.CreateResourceDialogUtils;
import org.jetbrains.android.actions.CreateResourceDirectoryDialogBase;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.actions.NewResourceCreationHandler;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceDirectoryAction
extends CreateResourceActionBase {
    private final ResourceFolderType myResourceFolderType;

    public CreateResourceDirectoryAction() {
        this(null);
    }

    public CreateResourceDirectoryAction(@Nullable ResourceFolderType resourceFolderType) {
        super(AndroidBundle.message("new.resource.dir.action.title", new Object[0]), AndroidBundle.message("new.resource.action.description", new Object[0]), PlatformIcons.FOLDER_ICON);
        this.myResourceFolderType = resourceFolderType;
    }

    @NotNull
    public PsiElement[] invokeDialog(@NotNull Project project, @NotNull PsiDirectory directory) {
        NewResourceCreationHandler newResourceHandler = NewResourceCreationHandler.getInstance(project);
        CreateResourceDirectoryDialogBase dialog2 = newResourceHandler.createNewResourceDirectoryDialog(project, AndroidPsiUtils.getModuleSafely((PsiElement)directory), this.myResourceFolderType, directory, null, resDirectory -> new CreateResourceActionBase.MyInputValidator(project, resDirectory));
        dialog2.setTitle(AndroidBundle.message("new.resource.dir.dialog.title", new Object[0]));
        if (!dialog2.showAndGet()) {
            return PsiElement.EMPTY_ARRAY;
        }
        return dialog2.getCreatedElements();
    }

    @Override
    @NotNull
    public PsiElement[] invokeDialog(@NotNull Project project, @NotNull DataContext dataContext) {
        ResourceFolderType folderType = this.myResourceFolderType;
        if (folderType == null) {
            VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
            folderType = CreateResourceFileAction.getUniqueFolderType(files2);
        }
        NewResourceCreationHandler newResourceHandler = NewResourceCreationHandler.getInstance(project);
        CreateResourceDirectoryDialogBase dialog2 = newResourceHandler.createNewResourceDirectoryDialog(project, (Module)PlatformCoreDataKeys.MODULE.getData(dataContext), folderType, CreateResourceDialogUtils.findResourceDirectory(dataContext), dataContext, resDirectory -> new CreateResourceActionBase.MyInputValidator(project, resDirectory));
        dialog2.setTitle(AndroidBundle.message("new.resource.dir.dialog.title", new Object[0]));
        if (!dialog2.showAndGet()) {
            return PsiElement.EMPTY_ARRAY;
        }
        return dialog2.getCreatedElements();
    }

    @Override
    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        return new PsiElement[]{directory.createSubdirectory(newName)};
    }

    @Override
    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    @Override
    protected String getCommandName() {
        return AndroidBundle.message("new.resource.dir.command.name", new Object[0]);
    }

    @Override
    @Nullable
    protected String getActionName(PsiDirectory directory, String newName) {
        return AndroidBundle.message("new.resource.dir.action.name", directory.getName() + File.separator + newName);
    }

    @Override
    protected boolean isAvailable(DataContext context) {
        if (!super.isAvailable(context)) {
            return false;
        }
        return CreateResourceFileAction.isOutsideResourceTypeFolder(context);
    }
}

