/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.samples;

import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.ui.StudioWizardDialogBuilder;
import com.appspot.gsamplesindex.samplesindex.SamplesIndex;
import com.appspot.gsamplesindex.samplesindex.model.SampleCollection;
import com.google.gct.studio.samples.SampleBrowserStep;
import com.google.gct.studio.samples.SampleModel;
import com.google.gct.studio.samples.SamplesBrowserBundle;
import com.google.gct.studio.samples.SamplesService;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import icons.SampleImportIcons;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class SampleImportAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(SampleImportAction.class);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        if (NewWelcomeScreen.isNewWelcomeScreen((AnActionEvent)e)) {
            e.getPresentation().setIcon(SampleImportIcons.Welcome.IMPORT_CODE_SAMPLE);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        final AtomicReference<Object> sampleList = new AtomicReference<Object>(null);
        final SamplesIndex samplesIndex = SamplesService.getInstance().getIndex();
        new Task.Modal(this, null, SamplesBrowserBundle.message("sample.import.title", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setText(SamplesBrowserBundle.message("sample.index.downloading", new Object[0]));
                try {
                    sampleList.set((SampleCollection)((Object)samplesIndex.samples().listSamples().set("technology", "android").execute()));
                }
                catch (IOException ex) {
                    LOG.warn(SamplesBrowserBundle.message("sample.index.download.failed", new Object[0]));
                    sampleList.set(null);
                }
            }
        }.queue();
        if (sampleList.get() == null || ((SampleCollection)sampleList.get()).isEmpty()) {
            Messages.showErrorDialog((String)SamplesBrowserBundle.message("sample.index.download.failed", new Object[0]), (String)SamplesBrowserBundle.message("sample.import.error.title", new Object[0]));
            return;
        }
        if (!AndroidSdkUtils.isAndroidSdkAvailable()) {
            String title2 = "SDK problem";
            String msg = "<html>Your Android SDK is missing or out of date.<br>You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>";
            Messages.showErrorDialog((String)msg, (String)title2);
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            SampleModel model = new SampleModel();
            ModelWizard.Builder wizardBuilder = new ModelWizard.Builder(new ModelWizardStep[0]);
            wizardBuilder.addStep(new SampleBrowserStep(model, (SampleCollection)((Object)((Object)sampleList.get()))));
            ModelWizard wizard2 = wizardBuilder.build();
            StudioWizardDialogBuilder builder = new StudioWizardDialogBuilder(wizard2, SamplesBrowserBundle.message("sample.import.title", new Object[0]));
            try {
                builder = builder.setHelpUrl(new URL("https://developer.android.com/r/studio-ui/import-sample.html"));
            }
            catch (MalformedURLException urlError) {
                throw new RuntimeException(urlError);
            }
            ModelWizardDialog dialog2 = builder.build();
            dialog2.show();
        });
    }
}

