/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login2;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.gct.login2.OAuthServer;
import com.google.gct.login2.OAuthServerKt;
import com.google.gct.login2.StudioClientInfo;
import com.google.gct.login2.common.AuthorizationCodeHolder;
import com.intellij.util.io.HttpRequests;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/google/gct/login2/GoogleOAuthServer;", "Lcom/google/gct/login2/OAuthServer;", "transport", "Lcom/google/api/client/http/HttpTransport;", "<init>", "(Lcom/google/api/client/http/HttpTransport;)V", "getToken", "Lcom/google/api/client/googleapis/auth/oauth2/GoogleTokenResponse;", "authorizationCodeHolder", "Lcom/google/gct/login2/common/AuthorizationCodeHolder;", "revokeToken", "", "token", "", "google-login"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nOAuthServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuthServer.kt\ncom/google/gct/login2/GoogleOAuthServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class GoogleOAuthServer
implements OAuthServer {
    @NotNull
    private final HttpTransport transport;
    public static final int $stable = 8;

    public GoogleOAuthServer(@NotNull HttpTransport transport) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        this.transport = transport;
    }

    @Override
    @NotNull
    public GoogleTokenResponse getToken(@NotNull AuthorizationCodeHolder authorizationCodeHolder) {
        GoogleAuthorizationCodeTokenRequest googleAuthorizationCodeTokenRequest;
        Intrinsics.checkNotNullParameter((Object)authorizationCodeHolder, (String)"authorizationCodeHolder");
        GoogleClientSecrets secrets = StudioClientInfo.Companion.getInstance().getLoginSecrets();
        GoogleAuthorizationCodeTokenRequest $this$getToken_u24lambda_u240 = googleAuthorizationCodeTokenRequest = new GoogleAuthorizationCodeTokenRequest(this.transport, (JsonFactory)new GsonFactory(), OAuthServerKt.getTokenUrl(), secrets.getDetails().getClientId(), secrets.getDetails().getClientSecret(), authorizationCodeHolder.getAuthorizationCode(), authorizationCodeHolder.getRedirectUrl());
        boolean bl = false;
        $this$getToken_u24lambda_u240.set("code_verifier", (Object)authorizationCodeHolder.getCodeVerifier());
        GoogleTokenResponse googleTokenResponse = googleAuthorizationCodeTokenRequest.execute();
        Intrinsics.checkNotNullExpressionValue((Object)googleTokenResponse, (String)"execute(...)");
        return googleTokenResponse;
    }

    @Override
    public void revokeToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        String url = OAuthServerKt.access$getRevokeUrl() + "?token=" + token;
        HttpRequests.post((String)url, (String)ContentType.APPLICATION_FORM_URLENCODED.toString()).productNameAsUserAgent().connectTimeout(3000).write("");
    }
}

