/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sdk;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.AndroidVersionUtils;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompatibilityRenderTarget
implements IAndroidTarget {
    private final int myApiLevel;
    private final IAndroidTarget myDelegate;
    private final AndroidVersion myVersion;
    private final IAndroidTarget myRealTarget;
    private final String myHashString;

    public CompatibilityRenderTarget(@NotNull IAndroidTarget delegate2, int apiLevel, @Nullable IAndroidTarget realTarget) {
        this.myDelegate = delegate2;
        this.myApiLevel = apiLevel;
        this.myRealTarget = realTarget;
        this.myVersion = realTarget != null ? realTarget.getVersion() : new AndroidVersion(apiLevel, null);
        this.myHashString = "compat-" + AndroidTargetHash.getPlatformHashString((AndroidVersion)this.myVersion);
    }

    public static IAndroidTarget copyWithNewDelegate(@NotNull CompatibilityRenderTarget original, @NotNull IAndroidTarget newDelegate) {
        return new CompatibilityRenderTarget(newDelegate, original.myApiLevel, original.myRealTarget);
    }

    @NotNull
    public IAndroidTarget getRenderTarget() {
        return this.myDelegate;
    }

    @Nullable
    public IAndroidTarget getRealTarget() {
        return this.myRealTarget;
    }

    @NotNull
    public AndroidVersion getVersion() {
        return this.myVersion;
    }

    public String getVersionName() {
        return AndroidVersionUtils.getFullApiName((AndroidVersion)this.myVersion, (boolean)true, (boolean)true);
    }

    public String hashString() {
        return this.myHashString;
    }

    public int compareTo(@NotNull IAndroidTarget other) {
        int delta = this.myApiLevel - other.getVersion().getApiLevel();
        if (delta != 0) {
            return delta;
        }
        return this.myDelegate.compareTo((Object)other);
    }

    public int getRevision() {
        return 1;
    }

    @NotNull
    public Path getPath(int pathId) {
        return this.myDelegate.getPath(pathId);
    }

    @NotNull
    public String getLocation() {
        return this.myDelegate.getLocation();
    }

    public String getVendor() {
        return this.myDelegate.getVendor();
    }

    public String getName() {
        return this.myDelegate.getName();
    }

    public String getFullName() {
        return this.myDelegate.getFullName();
    }

    public String getClasspathName() {
        return this.myDelegate.getClasspathName();
    }

    public String getShortClasspathName() {
        return this.myDelegate.getShortClasspathName();
    }

    public boolean isPlatform() {
        return this.myDelegate.isPlatform();
    }

    public IAndroidTarget getParent() {
        return this.myDelegate.getParent();
    }

    public BuildToolInfo getBuildToolInfo() {
        return this.myDelegate.getBuildToolInfo();
    }

    @NotNull
    public List<String> getBootClasspath() {
        return this.myDelegate.getBootClasspath();
    }

    public boolean hasRenderingLibrary() {
        return this.myDelegate.hasRenderingLibrary();
    }

    @NotNull
    public List<Path> getSkins() {
        return this.myDelegate.getSkins();
    }

    @Nullable
    public Path getDefaultSkin() {
        return this.myDelegate.getDefaultSkin();
    }

    @NotNull
    public List<OptionalLibrary> getOptionalLibraries() {
        return this.myDelegate.getOptionalLibraries();
    }

    @NotNull
    public List<OptionalLibrary> getAdditionalLibraries() {
        return this.myDelegate.getAdditionalLibraries();
    }

    public String[] getPlatformLibraries() {
        return this.myDelegate.getPlatformLibraries();
    }

    public String getProperty(String name2) {
        return this.myDelegate.getProperty(name2);
    }

    public Map<String, String> getProperties() {
        return this.myDelegate.getProperties();
    }

    public boolean canRunOn(IAndroidTarget target2) {
        return this.myDelegate.canRunOn(target2);
    }
}

