/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sdk;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.sdk.AndroidSdkData;
import com.android.tools.sdk.Annotations;
import org.jetbrains.annotations.NotNull;

public class AndroidPlatform {
    @NotNull
    private final AndroidSdkData mySdkData;
    @NotNull
    private final IAndroidTarget myTarget;

    public AndroidPlatform(@NotNull AndroidSdkData sdkData, @NotNull IAndroidTarget target2) {
        this.mySdkData = sdkData;
        this.myTarget = target2;
    }

    @NotNull
    public AndroidSdkData getSdkData() {
        return this.mySdkData;
    }

    @NotNull
    public IAndroidTarget getTarget() {
        return this.myTarget;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidPlatform platform = (AndroidPlatform)o;
        if (!this.mySdkData.equals(platform.mySdkData)) {
            return false;
        }
        return this.myTarget.equals((Object)platform.myTarget);
    }

    public int hashCode() {
        int result2 = this.mySdkData.hashCode();
        result2 = 31 * result2 + this.myTarget.hashCode();
        return result2;
    }

    public boolean needToAddAnnotationsJarToClasspath() {
        return Annotations.needsAnnotationsJarInClasspath(this.myTarget);
    }

    public int getApiLevel() {
        return this.myTarget.getVersion().getApiLevel();
    }

    @NotNull
    public AndroidVersion getApiVersion() {
        return this.myTarget.getVersion();
    }
}

