/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.resources.base.BasicResourceItem;
import com.android.resources.base.LoadableResourceRepository;
import com.android.resources.base.RepositoryLoader;
import com.android.tools.res.FolderResourceRepository;
import com.android.tools.res.LocalResourceRepository;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.File;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J&\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\rH\u0014J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020$H\u0014R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/res/FolderResourceRepository;", "Lcom/android/tools/res/LocalResourceRepository;", "Ljava/io/File;", "Lcom/android/resources/base/LoadableResourceRepository;", "resFolder", "<init>", "(Ljava/io/File;)V", "resourcePathPrefix", "", "resourcePathBase", "Lcom/android/ide/common/util/PathString;", "resourceTable", "", "Lcom/android/resources/ResourceType;", "Lcom/google/common/collect/ListMultimap;", "Lcom/android/ide/common/resources/ResourceItem;", "accept", "Lcom/android/ide/common/resources/ResourceVisitor$VisitResult;", "visitor", "Lcom/android/ide/common/resources/ResourceVisitor;", "getNamespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "getPackageName", "getLibraryName", "getOrigin", "Ljava/nio/file/Path;", "getResourceUrl", "relativeResourcePath", "getSourceFile", "forFileResource", "", "containsUserDefinedResources", "getMap", "namespace", "resourceType", "computeResourceDirs", "", "intellij.android.render-resources"})
public final class FolderResourceRepository
extends LocalResourceRepository<File>
implements LoadableResourceRepository {
    @NotNull
    private final File resFolder;
    @NotNull
    private final String resourcePathPrefix;
    @NotNull
    private final PathString resourcePathBase;
    @NotNull
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> resourceTable;

    public FolderResourceRepository(@NotNull File resFolder) {
        Intrinsics.checkNotNullParameter((Object)resFolder, (String)"resFolder");
        super("");
        this.resFolder = resFolder;
        this.resourcePathPrefix = RepositoryLoader.portableFileName((String)this.resFolder.getPath()) + "/";
        this.resourcePathBase = new PathString(this.resourcePathPrefix);
        this.resourceTable = new EnumMap(ResourceType.class);
        Path path = this.resFolder.toPath();
        ResourceNamespace resourceNamespace = this.getNamespace();
        RepositoryLoader<FolderResourceRepository> loader2 = new RepositoryLoader<FolderResourceRepository>(this, path, resourceNamespace){
            final /* synthetic */ FolderResourceRepository this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            protected void addResourceItem(BasicResourceItem item, FolderResourceRepository repository2) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
                FolderResourceRepository.access$getResourceTable$p(this.this$0).computeIfAbsent(item.getResourceType(), arg_0 -> loader.1.addResourceItem$lambda$1(loader.1::addResourceItem$lambda$0, arg_0)).put((Object)item.getName(), (Object)item);
            }

            private static final ListMultimap addResourceItem$lambda$0(ResourceType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (ListMultimap)LinkedListMultimap.create();
            }

            private static final ListMultimap addResourceItem$lambda$1(Function1 $tmp0, Object p0) {
                return (ListMultimap)$tmp0.invoke(p0);
            }
        };
        loader2.loadRepositoryContents((LoadableResourceRepository)this);
    }

    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (visitor2.shouldVisitNamespace(this.getNamespace())) {
            ResourceVisitor.VisitResult visitResult = LocalResourceRepository.acceptByResources(this.resourceTable, (ResourceVisitor)visitor2);
            Intrinsics.checkNotNullExpressionValue((Object)visitResult, (String)"acceptByResources(...)");
            return visitResult;
        }
        return ResourceVisitor.VisitResult.CONTINUE;
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        ResourceNamespace resourceNamespace = ResourceNamespace.RES_AUTO;
        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"RES_AUTO");
        return resourceNamespace;
    }

    @Nullable
    public String getPackageName() {
        return this.getNamespace().getPackageName();
    }

    @Nullable
    public String getLibraryName() {
        return null;
    }

    @NotNull
    public Path getOrigin() {
        Path path = this.resFolder.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    @NotNull
    public String getResourceUrl(@NotNull String relativeResourcePath) {
        Intrinsics.checkNotNullParameter((Object)relativeResourcePath, (String)"relativeResourcePath");
        return this.resourcePathPrefix + relativeResourcePath;
    }

    @NotNull
    public PathString getSourceFile(@NotNull String relativeResourcePath, boolean forFileResource) {
        Intrinsics.checkNotNullParameter((Object)relativeResourcePath, (String)"relativeResourcePath");
        return this.resourcePathBase.resolve(relativeResourcePath);
    }

    public boolean containsUserDefinedResources() {
        return true;
    }

    @Override
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
        return Intrinsics.areEqual((Object)namespace, (Object)this.getNamespace()) ? this.resourceTable.get(resourceType) : null;
    }

    @Override
    @NotNull
    protected Set<File> computeResourceDirs() {
        Object[] objectArray = new File[]{this.resFolder};
        return SetsKt.mutableSetOf((Object[])objectArray);
    }

    public static final /* synthetic */ Map access$getResourceTable$p(FolderResourceRepository $this) {
        return $this.resourceTable;
    }
}

