/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.parsers;

import com.android.AndroidXConstants;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.tools.module.ModuleDependencies;
import com.android.tools.rendering.parsers.DomPullParser;
import com.android.tools.rendering.parsers.LayoutPullParsers;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

class MenuLayoutParserFactory {
    @NotNull
    private static final String FRAME_LAYOUT_XML = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<FrameLayout\n    xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"match_parent\" />\n";

    private MenuLayoutParserFactory() {
    }

    @NotNull
    public static ILayoutPullParser create(@NotNull RenderXmlFile psiFile, @NotNull Consumer<String> menuResource) {
        Document frameLayoutDocument = XmlUtils.parseDocumentSilently((String)FRAME_LAYOUT_XML, (boolean)true);
        if (frameLayoutDocument == null) {
            return LayoutPullParsers.createEmptyParser();
        }
        menuResource.accept(psiFile.getName());
        return DomPullParser.createFromDocument(frameLayoutDocument, false);
    }

    @NotNull
    public static ILayoutPullParser createInNavigationView(@NotNull RenderXmlFile file, @NotNull ModuleDependencies dependencies2) {
        String navViewTag = dependencies2.dependsOnAndroidx() ? AndroidXConstants.NAVIGATION_VIEW.newName() : AndroidXConstants.NAVIGATION_VIEW.oldName();
        String xml = "<" + navViewTag + " xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    xmlns:app=\"http://schemas.android.com/apk/res-auto\"\n    android:layout_width=\"wrap_content\"\n    android:layout_height=\"match_parent\"\n    app:menu=\"@menu/" + SdkUtils.fileNameToResourceName((String)file.getName()) + "\" />\n";
        Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
        return document == null ? LayoutPullParsers.createEmptyParser() : DomPullParser.createFromDocument(document);
    }
}

