/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.parsers;

import com.android.AndroidXConstants;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceFolderType;
import com.android.tools.apk.analyzer.ResourceIdResolver;
import com.android.tools.fonts.DownloadableFontCacheService;
import com.android.tools.fonts.ProjectFonts;
import com.android.tools.rendering.IRenderLogger;
import com.android.tools.rendering.RenderTask;
import com.android.tools.rendering.api.NavGraphResolver;
import com.android.tools.rendering.parsers.DomPullParser;
import com.android.tools.rendering.parsers.LayoutRenderPullParser;
import com.android.tools.rendering.parsers.MenuLayoutParserFactory;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.android.tools.res.ResourceRepositoryManager;
import com.android.tools.res.ids.ResourceIdManagerHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.intellij.openapi.application.ApplicationManager;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LayoutPullParsers {
    static final boolean DEBUG = false;
    private static final String[] VALID_XML_TAGS = new String[]{"appwidget-provider", "PreferenceScreen", AndroidXConstants.PreferenceAndroidX.CLASS_PREFERENCE_SCREEN_ANDROIDX.oldName(), AndroidXConstants.PreferenceAndroidX.CLASS_PREFERENCE_SCREEN_ANDROIDX.newName()};
    private static final String[] ADAPTIVE_ICON_TAGS = new String[]{"adaptive-icon", "maskable-icon"};
    private static final String[] FONT_FAMILY_TAGS = new String[]{"font-family"};
    private static final EnumSet<ResourceFolderType> FOLDER_NEEDS_READ_ACCESS = EnumSet.of(ResourceFolderType.DRAWABLE, ResourceFolderType.MIPMAP, ResourceFolderType.MENU, ResourceFolderType.XML, ResourceFolderType.FONT);

    private LayoutPullParsers() {
    }

    private static boolean isXmlWithRootTag(@NotNull RenderXmlFile file, @NotNull String[] rootTags) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RenderXmlTag rootTag = file.getRootTag();
        if (rootTag == null) {
            return false;
        }
        String tag = rootTag.getName();
        for (String validRootTags : rootTags) {
            if (!validRootTags.equals(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupported(@NotNull RenderXmlFile file) {
        ResourceFolderType folderType = file.getFolderType();
        if (folderType == null) {
            return false;
        }
        switch (folderType) {
            case LAYOUT: 
            case DRAWABLE: 
            case MENU: {
                return true;
            }
            case MIPMAP: {
                return LayoutPullParsers.isXmlWithRootTag(file, ADAPTIVE_ICON_TAGS);
            }
            case XML: {
                return LayoutPullParsers.isXmlWithRootTag(file, VALID_XML_TAGS);
            }
            case FONT: {
                return LayoutPullParsers.isXmlWithRootTag(file, FONT_FAMILY_TAGS);
            }
        }
        return false;
    }

    @Nullable
    public static ILayoutPullParser create(@NotNull RenderTask renderTask) {
        ResourceFolderType folderType = renderTask.getContext().getFolderType();
        if (folderType == null) {
            return null;
        }
        if (FOLDER_NEEDS_READ_ACCESS.contains(folderType) && !ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (ILayoutPullParser)ApplicationManager.getApplication().runReadAction(() -> LayoutPullParsers.create(renderTask));
        }
        RenderXmlFile file = renderTask.getXmlFile();
        if (file == null) {
            throw new IllegalArgumentException("RenderTask always should always have PsiFile when it has ResourceFolderType");
        }
        ResourceRepositoryManager manager = renderTask.getContext().getModule().getResourceRepositoryManager();
        switch (folderType) {
            case LAYOUT: {
                IRenderLogger logger = renderTask.getLogger();
                ResourceResolver resourceResolver = renderTask.getContext().getConfiguration().getResourceResolver();
                NavGraphResolver navGraphResolver = renderTask.getContext().getModule().getEnvironment().getNavGraphResolver(resourceResolver);
                boolean useToolsNamespace = renderTask.getShowWithToolsVisibilityAndPosition();
                return LayoutRenderPullParser.create(file, logger, navGraphResolver, manager, useToolsNamespace);
            }
            case DRAWABLE: 
            case MIPMAP: {
                renderTask.setDecorations(false);
                return LayoutPullParsers.createDrawableParser(file);
            }
            case MENU: {
                renderTask.setDecorations(true);
                return LayoutPullParsers.createMenuParser(file, renderTask);
            }
            case XML: {
                RenderXmlTag rootTag = file.getRootTag();
                if (rootTag != null) {
                    String tag = rootTag.getName();
                    if (tag.equals("appwidget-provider")) {
                        renderTask.setDecorations(false);
                        return LayoutPullParsers.createWidgetParser(rootTag);
                    }
                    if (tag.equals("PreferenceScreen") || AndroidXConstants.PreferenceAndroidX.CLASS_PREFERENCE_SCREEN_ANDROIDX.isEquals(tag)) {
                        IRenderLogger logger = renderTask.getLogger();
                        ResourceResolver resourceResolver = renderTask.getContext().getConfiguration().getResourceResolver();
                        NavGraphResolver navGraphResolver = renderTask.getContext().getModule().getEnvironment().getNavGraphResolver(resourceResolver);
                        return LayoutRenderPullParser.create(file, logger, navGraphResolver, manager, true);
                    }
                }
                return null;
            }
            case FONT: {
                renderTask.setTransparentBackground();
                renderTask.setDecorations(false);
                renderTask.setRenderingMode(SessionParams.RenderingMode.V_SCROLL);
                ResourceIdResolver resolver = ResourceIdManagerHelper.getResolver(renderTask.getContext().getModule().getResourceIdManager());
                DownloadableFontCacheService fontService = renderTask.getContext().getModule().getEnvironment().getDownloadableFontCacheService();
                return LayoutPullParsers.createFontFamilyParser(file, fontName -> new ProjectFonts(fontService, manager, resolver).getFont((String)fontName), renderTask.getDefaultForegroundColor());
            }
        }
        assert (false) : folderType;
        return null;
    }

    private static ILayoutPullParser createDrawableParser(RenderXmlFile file) {
        String scaleType;
        Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element imageView = LayoutPullParsers.addRootElement(document, "ImageView", file.getResourceNamespace());
        LayoutPullParsers.setAndroidAttr(imageView, "layout_width", "fill_parent");
        LayoutPullParsers.setAndroidAttr(imageView, "layout_height", "fill_parent");
        ResourceFolderType type = file.getFolderType();
        assert (type != null);
        LayoutPullParsers.setAndroidAttr(imageView, "src", file.getRelativePath());
        String background = file.getRootTagAttribute("background", "http://schemas.android.com/tools");
        if (background != null && !background.isEmpty()) {
            LayoutPullParsers.setAndroidAttr(imageView, "background", background);
        }
        if ((scaleType = file.getRootTagAttribute("scaleType", "http://schemas.android.com/tools")) != null && !scaleType.isEmpty()) {
            LayoutPullParsers.setAndroidAttr(imageView, "scaleType", scaleType);
        }
        return DomPullParser.createFromDocument(document);
    }

    @NotNull
    private static ILayoutPullParser createMenuParser(@NotNull RenderXmlFile file, @NotNull RenderTask task2) {
        RenderXmlTag tag = file.getRootTag();
        if (tag != null && Objects.equals(tag.getAttributeValue("showIn", "http://schemas.android.com/tools"), "navigation_view")) {
            task2.setDecorations(false);
            return MenuLayoutParserFactory.createInNavigationView(file, task2.getContext().getModule().getDependencies());
        }
        return MenuLayoutParserFactory.create(file, task2::setMenuResource);
    }

    @Nullable
    private static ILayoutPullParser createWidgetParser(RenderXmlTag rootTag) {
        String layout = rootTag.getAttributeValue("initialLayout", "http://schemas.android.com/apk/res/android");
        String preview = rootTag.getAttributeValue("previewImage", "http://schemas.android.com/apk/res/android");
        if (layout == null && preview == null) {
            return null;
        }
        Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element root = LayoutPullParsers.addRootElement(document, layout != null ? "include" : "ImageView", rootTag.getResourceNamespace());
        if (layout != null) {
            root.setAttribute("layout", layout);
            LayoutPullParsers.setAndroidAttr(root, "layout_width", "fill_parent");
            LayoutPullParsers.setAndroidAttr(root, "layout_height", "fill_parent");
        } else {
            root.setAttribute("src", preview);
            LayoutPullParsers.setAndroidAttr(root, "layout_width", "wrap_content");
            LayoutPullParsers.setAndroidAttr(root, "layout_height", "wrap_content");
        }
        return DomPullParser.createFromDocument(document);
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    @Nullable
    public static ILayoutPullParser createFontFamilyParser(@NotNull RenderXmlFile file, @NotNull Function<String, FontFamily> getDownloadableFont, @NotNull String fontColor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.TernaryExpression.applyExpressionRewriter(TernaryExpression.java:106)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Element addRootElement(@NotNull Document document, @NotNull String tag, @Nullable ResourceNamespace namespace) {
        Element root = document.createElementNS(namespace != null ? namespace.getXmlNamespaceUri() : null, tag);
        Attr attr = document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:android");
        attr.setValue("http://schemas.android.com/apk/res/android");
        root.getAttributes().setNamedItemNS(attr);
        document.appendChild(root);
        return root;
    }

    public static Element setAndroidAttr(Element element, String name2, String value2) {
        element.setAttributeNS("http://schemas.android.com/apk/res/android", name2, value2);
        return element;
    }

    public static ILayoutPullParser createEmptyParser() {
        Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element root = LayoutPullParsers.addRootElement(document, "FrameLayout", null);
        LayoutPullParsers.setAndroidAttr(root, "layout_width", "fill_parent");
        LayoutPullParsers.setAndroidAttr(root, "layout_height", "fill_parent");
        return DomPullParser.createFromDocument(document);
    }

    private static /* synthetic */ void lambda$createFontFamilyParser$5(boolean[] hasElements, Document document, String loremText, String fontColor, Element rootLayout, String[] font) {
        hasElements[0] = true;
        Element fontElement = document.createElement("TextView");
        LayoutPullParsers.setAndroidAttr(fontElement, "layout_width", "wrap_content");
        LayoutPullParsers.setAndroidAttr(fontElement, "layout_height", "wrap_content");
        LayoutPullParsers.setAndroidAttr(fontElement, "text", loremText);
        LayoutPullParsers.setAndroidAttr(fontElement, "fontFamily", font[0]);
        LayoutPullParsers.setAndroidAttr(fontElement, "textSize", "30sp");
        LayoutPullParsers.setAndroidAttr(fontElement, "textColor", fontColor);
        LayoutPullParsers.setAndroidAttr(fontElement, "paddingBottom", "20dp");
        LayoutPullParsers.setAndroidAttr(fontElement, "textStyle", font[1]);
        rootLayout.appendChild(fontElement);
    }

    private static /* synthetic */ boolean lambda$createFontFamilyParser$4(String[] font) {
        return !Strings.isNullOrEmpty((String)font[0]);
    }
}

