/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.parsers;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.tools.rendering.parsers.LayoutPullParser;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DomPullParser
extends LayoutPullParser {
    @NotNull
    private final List<Element> myNodeStack;
    private final Element myRoot;
    private final boolean myElementAsCookie;

    private DomPullParser(Element root, boolean elementAsCookie) {
        this.myRoot = root;
        this.myNodeStack = new ArrayList<Element>();
        this.myElementAsCookie = elementAsCookie;
    }

    @VisibleForTesting
    public Element getRoot() {
        return this.myRoot;
    }

    protected Element getCurrentElement() {
        if (!this.myNodeStack.isEmpty()) {
            return this.myNodeStack.get(this.myNodeStack.size() - 1);
        }
        return null;
    }

    private Attr getAttribute(int i) {
        if (this.myParsingState != 2) {
            throw new IndexOutOfBoundsException();
        }
        Element element = this.getCurrentElement();
        if (element != null) {
            return (Attr)element.getAttributes().item(i);
        }
        return null;
    }

    private void push(@NotNull Element node) {
        this.myNodeStack.add(node);
    }

    @NotNull
    private Element pop() {
        return this.myNodeStack.remove(this.myNodeStack.size() - 1);
    }

    public Object getViewCookie() {
        if (this.myElementAsCookie) {
            return this.getCurrentElement();
        }
        return null;
    }

    public ResourceNamespace getLayoutNamespace() {
        if (this.myRoot == null) {
            return ResourceNamespace.RES_AUTO;
        }
        String uri = this.myRoot.getNamespaceURI();
        if (uri == null) {
            return ResourceNamespace.RES_AUTO;
        }
        ResourceNamespace namespace = ResourceNamespace.fromNamespaceUri((String)uri);
        return namespace != null ? namespace : ResourceNamespace.RES_AUTO;
    }

    public String getPositionDescription() {
        return "XML DOM element depth:" + this.myNodeStack.size();
    }

    public int getAttributeCount() {
        Element node = this.getCurrentElement();
        if (node != null) {
            return node.getAttributes().getLength();
        }
        return 0;
    }

    public String getAttributeName(int i) {
        Attr attribute2 = this.getAttribute(i);
        if (attribute2 != null) {
            String localName = attribute2.getLocalName();
            if (localName == null) {
                return attribute2.getName();
            }
            return localName;
        }
        return null;
    }

    public String getAttributeNamespace(int i) {
        Attr attribute2 = this.getAttribute(i);
        if (attribute2 != null) {
            return attribute2.getNamespaceURI();
        }
        return "";
    }

    public String getAttributePrefix(int i) {
        Attr attribute2 = this.getAttribute(i);
        if (attribute2 != null) {
            return attribute2.getPrefix();
        }
        return null;
    }

    public String getAttributeValue(int i) {
        Attr attribute2 = this.getAttribute(i);
        if (attribute2 != null) {
            return attribute2.getValue();
        }
        return null;
    }

    public String getAttributeValue(String namespace, String localName) {
        Element element = this.getCurrentElement();
        if (element != null) {
            Attr attribute2 = element.getAttributeNodeNS(namespace, localName);
            if (attribute2 == null && namespace != null && !namespace.equals("http://schemas.android.com/apk/res/android")) {
                attribute2 = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", localName);
            }
            if (attribute2 != null) {
                return attribute2.getValue();
            }
        }
        return null;
    }

    public int getDepth() {
        return this.myNodeStack.size();
    }

    public String getName() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            Element currentNode = this.getCurrentElement();
            assert (currentNode != null);
            return currentNode.getTagName();
        }
        return null;
    }

    public String getNamespace() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            Element currentNode = this.getCurrentElement();
            assert (currentNode != null);
            return currentNode.getNamespaceURI();
        }
        return null;
    }

    public String getPrefix() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            Element currentNode = this.getCurrentElement();
            assert (currentNode != null);
            return currentNode.getPrefix();
        }
        return null;
    }

    public String getNamespace(String prefix) {
        Element currentNode = this.getCurrentElement();
        return currentNode != null ? currentNode.lookupNamespaceURI(prefix) : null;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.myParsingState == 2) {
            Element currentNode = this.getCurrentElement();
            assert (currentNode != null);
            return currentNode.getChildNodes().getLength() == 0;
        }
        throw new XmlPullParserException("Call to isEmptyElementTag while not in START_TAG", (XmlPullParser)this, null);
    }

    @Override
    protected void onNextFromStartDocument() {
        if (this.myRoot != null) {
            this.push(this.myRoot);
            this.myParsingState = 2;
        } else {
            this.myParsingState = 1;
        }
    }

    @Override
    protected void onNextFromStartTag() {
        Element node = this.getCurrentElement();
        assert (node != null);
        Element first = XmlUtils.getFirstSubTag((Node)node);
        if (first != null) {
            this.push(first);
            this.myParsingState = 2;
        } else {
            this.myParsingState = this.myParsingState == 0 ? 1 : 3;
        }
    }

    @Override
    protected void onNextFromEndTag() {
        Node sibling;
        Element node = this.getCurrentElement();
        assert (node != null);
        for (sibling = node.getNextSibling(); sibling != null && !(sibling instanceof Element); sibling = sibling.getNextSibling()) {
        }
        if (sibling != null) {
            node = (Element)sibling;
            this.pop();
            this.push(node);
            this.myParsingState = 2;
        } else {
            this.pop();
            this.myParsingState = this.myNodeStack.isEmpty() ? 1 : 3;
        }
    }

    private static DocumentBuilder createNewDocumentBuilder() {
        DocumentBuilderFactory factory2 = DocumentBuilderFactory.newDefaultInstance();
        factory2.setNamespaceAware(true);
        factory2.setValidating(false);
        factory2.setIgnoringComments(true);
        try {
            return factory2.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Logger.getInstance(DomPullParser.class).error((Throwable)e);
            return null;
        }
    }

    public static Document createEmptyPlainDocument() {
        DocumentBuilder builder = DomPullParser.createNewDocumentBuilder();
        return builder != null ? builder.newDocument() : null;
    }

    @NotNull
    public static ILayoutPullParser createFromDocument(@NotNull Document document) {
        return new DomPullParser(document.getDocumentElement(), true);
    }

    @NotNull
    public static ILayoutPullParser createFromDocument(@NotNull Document document, boolean elementAsCookie) {
        return new DomPullParser(document.getDocumentElement(), elementAsCookie);
    }
}

