/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.imagepool;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ImagePool {
    public static final Image NULL_POOLED_IMAGE = new Image(){

        @Override
        public int getWidth() {
            return 0;
        }

        @Override
        public int getHeight() {
            return 0;
        }

        @Override
        public void drawImageTo(@NotNull Graphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        }

        @Override
        public void paint(Consumer<Graphics2D> command) {
        }

        @Override
        @Nullable
        public BufferedImage getCopy(@Nullable GraphicsConfiguration gc, int x, int y, int w, int h) {
            return null;
        }

        @Override
        public boolean isValid() {
            return false;
        }
    };

    @NotNull
    public Image create(int var1, int var2, int var3);

    @NotNull
    public Image copyOf(@Nullable BufferedImage var1);

    @Nullable
    public Stats getStats();

    public void dispose();

    public static interface Image {
        public int getWidth();

        public int getHeight();

        public void drawImageTo(@NotNull Graphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

        public void paint(Consumer<Graphics2D> var1);

        default public void drawImageTo(@NotNull Graphics g, int x, int y, int w, int h) {
            this.drawImageTo(g, x, y, x + w, y + h, 0, 0, this.getWidth(), this.getHeight());
        }

        default public void drawImageTo(@NotNull BufferedImage destination) {
            Graphics g = destination.getGraphics();
            try {
                this.drawImageTo(g, 0, 0, destination.getWidth(), destination.getHeight());
            }
            finally {
                g.dispose();
            }
        }

        @Nullable
        public BufferedImage getCopy(@Nullable GraphicsConfiguration var1, int var2, int var3, int var4, int var5);

        @Nullable
        default public BufferedImage getCopy(int x, int y, int w, int h) {
            return this.getCopy(null, x, y, w, h);
        }

        @Nullable
        default public BufferedImage getCopy(@NotNull GraphicsConfiguration gc) {
            return this.getCopy(gc, 0, 0, this.getWidth(), this.getHeight());
        }

        @Nullable
        default public BufferedImage getCopy() {
            return this.getCopy(null, 0, 0, this.getWidth(), this.getHeight());
        }

        public boolean isValid();
    }

    public static interface Stats {
        public long totalBytesAllocated();

        public long totalBytesInUse();

        public BucketStats[] getBucketStats();
    }

    public static interface BucketStats {
        public int getMinWidth();

        public int getMinHeight();

        public int maxSize();

        public long getLastAccessTimeMs();

        public long bucketHits();

        public long bucketMisses();

        public long bucketWasFull();

        public long imageWasReturned();
    }
}

