/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import com.android.ide.common.rendering.api.IImageFactory;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/rendering/ConstrainedImageFactory;", "Lcom/android/ide/common/rendering/api/IImageFactory;", "maxImageSize", "", "qualityProvider", "Lkotlin/Function0;", "", "delegate", "<init>", "(JLkotlin/jvm/functions/Function0;Lcom/android/ide/common/rendering/api/IImageFactory;)V", "getImage", "Ljava/awt/image/BufferedImage;", "width", "", "height", "intellij.android.rendering"})
public final class ConstrainedImageFactory
implements IImageFactory {
    private final long maxImageSize;
    @NotNull
    private final Function0<Float> qualityProvider;
    @NotNull
    private final IImageFactory delegate;

    public ConstrainedImageFactory(long maxImageSize, @NotNull Function0<Float> qualityProvider, @NotNull IImageFactory delegate2) {
        Intrinsics.checkNotNullParameter(qualityProvider, (String)"qualityProvider");
        Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
        this.maxImageSize = maxImageSize;
        this.qualityProvider = qualityProvider;
        this.delegate = delegate2;
    }

    @NotNull
    public BufferedImage getImage(int width, int height) {
        long wantedImageSize = Math.max(1L, (long)width * (long)height);
        double quality = RangesKt.coerceIn((double)((Number)this.qualityProvider.invoke()).floatValue(), (double)1.0E-6, (double)1.0);
        double qualityDimensionScale = Math.sqrt(quality);
        double maxSizeDimensionScale = Math.sqrt((double)this.maxImageSize / (double)wantedImageSize);
        double dimensionScale = Math.min(qualityDimensionScale, maxSizeDimensionScale);
        double downscaleWidth = (double)width * dimensionScale;
        double downscaleHeight = (double)height * dimensionScale;
        int w = Math.max(1, (int)downscaleWidth);
        int h = Math.max(1, (int)downscaleHeight);
        BufferedImage bufferedImage = this.delegate.getImage(w, h);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"getImage(...)");
        return bufferedImage;
    }
}

