/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.model;

import com.android.tools.adtui.model.stdui.ValueChangedListener;
import com.android.tools.property.panel.api.InspectorLineModel;
import com.android.tools.property.panel.api.PropertyEditorModel;
import com.android.tools.property.panel.api.TableLineModel;
import com.android.tools.property.panel.impl.model.CollapsibleLabelModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.text.Matcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\bJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0014J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0006J\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0006J\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u0014H\u0002J\b\u0010\"\u001a\u00020\u0014H\u0002J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u0014H\u0002J\b\u0010&\u001a\u00020\u0014H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0003\u001a\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006'"}, d2={"Lcom/android/tools/property/panel/impl/model/InspectorPanelModel;", "", "<init>", "()V", "listeners", "", "Lcom/android/tools/adtui/model/stdui/ValueChangedListener;", "lines", "Lcom/android/tools/property/panel/api/InspectorLineModel;", "getLines$annotations", "getLines", "()Ljava/util/List;", "value", "", "filter", "getFilter", "()Ljava/lang/String;", "setFilter", "(Ljava/lang/String;)V", "clear", "", "moveToNextLineEditor", "line", "findClosestNextLine", "lineIndex", "", "propertyValuesChanged", "add", "addValueChangedListener", "listener", "removeValueChangedListener", "enterInFilter", "", "updateFiltering", "applyFilter", "applyFilterToTable", "Lcom/android/tools/property/panel/api/TableLineModel;", "restoreGroups", "fireValueChanged", "intellij.android.layout-ui"})
@SourceDebugExtension(value={"SMAP\nInspectorPanelModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectorPanelModel.kt\ncom/android/tools/property/panel/impl/model/InspectorPanelModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,154:1\n1869#2,2:155\n774#2:157\n865#2,2:158\n1869#2,2:160\n1869#2,2:162\n37#3:164\n36#3,3:165\n13472#4,2:168\n*S KotlinDebug\n*F\n+ 1 InspectorPanelModel.kt\ncom/android/tools/property/panel/impl/model/InspectorPanelModel\n*L\n76#1:155,2\n96#1:157\n96#1:158,2\n125#1:160,2\n141#1:162,2\n151#1:164\n151#1:165,3\n151#1:168,2\n*E\n"})
public final class InspectorPanelModel {
    @NotNull
    private List<ValueChangedListener> listeners = new ArrayList();
    @NotNull
    private final List<InspectorLineModel> lines = new ArrayList();
    @NotNull
    private String filter = "";

    @NotNull
    public final List<InspectorLineModel> getLines() {
        return this.lines;
    }

    @VisibleForTesting
    public static /* synthetic */ void getLines$annotations() {
    }

    @NotNull
    public final String getFilter() {
        return this.filter;
    }

    public final void setFilter(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.filter = value2;
        this.updateFiltering();
    }

    public final void clear() {
        this.lines.clear();
    }

    public final void moveToNextLineEditor(@NotNull InspectorLineModel line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        int index = this.lines.indexOf(line);
        if (index < 0) {
            return;
        }
        InspectorLineModel inspectorLineModel = this.findClosestNextLine(index);
        if (inspectorLineModel == null) {
            return;
        }
        InspectorLineModel nextLine = inspectorLineModel;
        nextLine.requestFocus();
    }

    private final InspectorLineModel findClosestNextLine(int lineIndex) {
        int index = (lineIndex + 1) % this.lines.size();
        while (index != lineIndex) {
            InspectorLineModel line = this.lines.get(index);
            if (line.getVisible() && line.getFocusable()) {
                return line;
            }
            index = (index + 1) % this.lines.size();
        }
        return null;
    }

    public final void propertyValuesChanged() {
        Iterable $this$forEach$iv = this.lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InspectorLineModel it = (InspectorLineModel)element$iv;
            boolean bl = false;
            it.refresh();
        }
    }

    public final void add(@NotNull InspectorLineModel line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.lines.add(line);
    }

    public final void addValueChangedListener(@NotNull ValueChangedListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public final void removeValueChangedListener(@NotNull ValueChangedListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean enterInFilter() {
        void $this$filterTo$iv$iv;
        if (((CharSequence)this.filter).length() == 0) {
            return false;
        }
        Iterable $this$filter$iv = this.lines;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            InspectorLineModel it = (InspectorLineModel)element$iv$iv;
            boolean bl = false;
            if (!(it.getVisible() && (it instanceof CollapsibleLabelModel || it instanceof TableLineModel))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List visibleLabels = (List)destination$iv$iv;
        if (((Collection)visibleLabels).size() != 1) {
            return false;
        }
        InspectorLineModel label2 = (InspectorLineModel)visibleLabels.get(0);
        if (label2 instanceof CollapsibleLabelModel) {
            PropertyEditorModel propertyEditorModel = ((CollapsibleLabelModel)label2).getEditorModel();
            if (propertyEditorModel == null) {
                return false;
            }
            PropertyEditorModel editor = propertyEditorModel;
            editor.requestFocus();
            return true;
        }
        if (label2 instanceof TableLineModel) {
            ((TableLineModel)label2).requestFocusInBestMatch();
            return true;
        }
        return false;
    }

    private final void updateFiltering() {
        if (((CharSequence)this.filter).length() > 0) {
            this.applyFilter();
        } else {
            this.restoreGroups();
        }
        this.fireValueChanged();
    }

    private final void applyFilter() {
        MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + this.filter)).build();
        Iterable $this$forEach$iv = this.lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InspectorLineModel line = (InspectorLineModel)element$iv;
            boolean bl = false;
            if (!line.isSearchable()) {
                line.setVisible(false);
                continue;
            }
            if (line instanceof CollapsibleLabelModel) {
                CollapsibleLabelModel collapsibleLabelModel = (CollapsibleLabelModel)line;
                CollapsibleLabelModel collapsibleLabelModel2 = (CollapsibleLabelModel)line;
                Intrinsics.checkNotNull((Object)matcher);
                collapsibleLabelModel.hideForSearch(collapsibleLabelModel2.isMatch((Matcher)matcher));
                continue;
            }
            if (line instanceof TableLineModel) {
                this.applyFilterToTable((TableLineModel)line);
                continue;
            }
            Intrinsics.checkNotNull((Object)matcher);
            line.setVisible(line.isMatch((Matcher)matcher));
        }
    }

    private final void applyFilterToTable(TableLineModel line) {
        line.setFilter(this.filter);
        line.setVisible(line.getItemCount() > 0);
    }

    private final void restoreGroups() {
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)this.lines);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InspectorLineModel line = (InspectorLineModel)element$iv;
            boolean bl = false;
            if (line instanceof CollapsibleLabelModel) {
                ((CollapsibleLabelModel)line).restoreAfterSearch();
                continue;
            }
            if (line.isSearchable()) {
                line.setFilter("");
                continue;
            }
            line.setVisible(true);
        }
    }

    private final void fireValueChanged() {
        Collection $this$toTypedArray$iv = this.listeners;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ValueChangedListener[] $this$forEach$iv = thisCollection$iv.toArray(new ValueChangedListener[0]);
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ValueChangedListener element$iv;
            ValueChangedListener it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.valueChanged();
        }
    }
}

