/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.preview.config;

import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.tools.preview.config.WindowSizeDataKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0006H\u00c6\u0003J\t\u0010!\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\t\u0010#\u001a\u00020\u000bH\u00c6\u0003JE\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u0019H\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006*"}, d2={"Lcom/android/tools/preview/config/WindowSizeData;", "", "id", "", "name", "widthDp", "", "heightDp", "density", "Lcom/android/resources/Density;", "defaultOrientation", "Lcom/android/resources/ScreenOrientation;", "<init>", "(Ljava/lang/String;Ljava/lang/String;DDLcom/android/resources/Density;Lcom/android/resources/ScreenOrientation;)V", "getId", "()Ljava/lang/String;", "getName", "getWidthDp", "()D", "getHeightDp", "getDensity", "()Lcom/android/resources/Density;", "getDefaultOrientation", "()Lcom/android/resources/ScreenOrientation;", "widthPx", "", "getWidthPx", "()I", "heightPx", "getHeightPx", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "intellij.android.preview-elements"})
public final class WindowSizeData {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    private final double widthDp;
    private final double heightDp;
    @NotNull
    private final Density density;
    @NotNull
    private final ScreenOrientation defaultOrientation;
    private final int widthPx;
    private final int heightPx;

    public WindowSizeData(@NotNull String id2, @NotNull String name2, double widthDp, double heightDp, @NotNull Density density, @NotNull ScreenOrientation defaultOrientation) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)defaultOrientation, (String)"defaultOrientation");
        this.id = id2;
        this.name = name2;
        this.widthDp = widthDp;
        this.heightDp = heightDp;
        this.density = density;
        this.defaultOrientation = defaultOrientation;
        this.widthPx = WindowSizeDataKt.toPx(this.widthDp, this.density);
        this.heightPx = WindowSizeDataKt.toPx(this.heightDp, this.density);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final double getWidthDp() {
        return this.widthDp;
    }

    public final double getHeightDp() {
        return this.heightDp;
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    @NotNull
    public final ScreenOrientation getDefaultOrientation() {
        return this.defaultOrientation;
    }

    public final int getWidthPx() {
        return this.widthPx;
    }

    public final int getHeightPx() {
        return this.heightPx;
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    public final double component3() {
        return this.widthDp;
    }

    public final double component4() {
        return this.heightDp;
    }

    @NotNull
    public final Density component5() {
        return this.density;
    }

    @NotNull
    public final ScreenOrientation component6() {
        return this.defaultOrientation;
    }

    @NotNull
    public final WindowSizeData copy(@NotNull String id2, @NotNull String name2, double widthDp, double heightDp, @NotNull Density density, @NotNull ScreenOrientation defaultOrientation) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)defaultOrientation, (String)"defaultOrientation");
        return new WindowSizeData(id2, name2, widthDp, heightDp, density, defaultOrientation);
    }

    public static /* synthetic */ WindowSizeData copy$default(WindowSizeData windowSizeData, String string, String string2, double d, double d2, Density density, ScreenOrientation screenOrientation, int n, Object object) {
        if ((n & 1) != 0) {
            string = windowSizeData.id;
        }
        if ((n & 2) != 0) {
            string2 = windowSizeData.name;
        }
        if ((n & 4) != 0) {
            d = windowSizeData.widthDp;
        }
        if ((n & 8) != 0) {
            d2 = windowSizeData.heightDp;
        }
        if ((n & 0x10) != 0) {
            density = windowSizeData.density;
        }
        if ((n & 0x20) != 0) {
            screenOrientation = windowSizeData.defaultOrientation;
        }
        return windowSizeData.copy(string, string2, d, d2, density, screenOrientation);
    }

    @NotNull
    public String toString() {
        return "WindowSizeData(id=" + this.id + ", name=" + this.name + ", widthDp=" + this.widthDp + ", heightDp=" + this.heightDp + ", density=" + this.density + ", defaultOrientation=" + this.defaultOrientation + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + Double.hashCode(this.widthDp);
        result2 = result2 * 31 + Double.hashCode(this.heightDp);
        result2 = result2 * 31 + this.density.hashCode();
        result2 = result2 * 31 + this.defaultOrientation.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WindowSizeData)) {
            return false;
        }
        WindowSizeData windowSizeData = (WindowSizeData)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)windowSizeData.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)windowSizeData.name)) {
            return false;
        }
        if (Double.compare(this.widthDp, windowSizeData.widthDp) != 0) {
            return false;
        }
        if (Double.compare(this.heightDp, windowSizeData.heightDp) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.density, (Object)windowSizeData.density)) {
            return false;
        }
        return this.defaultOrientation == windowSizeData.defaultOrientation;
    }
}

