/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.preview.config;

import com.android.resources.Density;
import java.util.ArrayList;
import java.util.Collections;

public class Densities {
    private static Density[] ourCommonDensities;

    public static Density getScreenDensity(boolean isTv, double dpi, int screenHeight) {
        return Densities.lookupDensity(isTv, dpi, screenHeight, Density.values());
    }

    public static Density getCommonScreenDensity(boolean isTv, double dpi, int screenHeight) {
        return Densities.lookupDensity(isTv, dpi, screenHeight, Densities.getCommonDensities());
    }

    private static Density lookupDensity(boolean isTv, double dpi, int screenHeight, Density[] densities) {
        if (isTv) {
            return screenHeight <= 720 ? Density.TV : Density.XHIGH;
        }
        Density bucket = Density.MEDIUM;
        double minDifference = Double.MAX_VALUE;
        for (Density bucketDensity : densities) {
            double difference;
            if (!bucketDensity.isValidValueForDevice() || bucketDensity == Density.TV || !((difference = Math.abs((double)bucketDensity.getDpiValue() - dpi)) < minDifference)) continue;
            minDifference = difference;
            bucket = bucketDensity;
        }
        return bucket;
    }

    private static Density[] getCommonDensities() {
        if (ourCommonDensities == null) {
            ArrayList<Density> densities = new ArrayList<Density>();
            Collections.addAll(densities, Density.values());
            densities.add(Density.create((int)560));
            densities.add(Density.create((int)440));
            densities.add(Density.create((int)420));
            densities.add(Density.create((int)360));
            densities.add(Density.create((int)340));
            densities.add(Density.create((int)300));
            densities.add(Density.create((int)280));
            densities.add(Density.create((int)260));
            densities.add(Density.create((int)220));
            densities.add(Density.create((int)200));
            densities.add(Density.create((int)180));
            densities.add(Density.create((int)140));
            densities.sort(Density::compareTo);
            ourCommonDensities = densities.toArray(new Density[0]);
        }
        return ourCommonDensities;
    }
}

