/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.sdklib.devices.Storage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001\u001a \u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0000\u00a8\u0006\u0012"}, d2={"getSizeLabel", "", "size", "", "roundToNumberOfDigits", "number", "", "maxDigits", "", "getMessageWithDetails", "message", "details", "invokeLater", "", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "block", "Lkotlin/Function0;", "intellij.android.core"})
@JvmName(name="WelcomeUiUtils")
@SourceDebugExtension(value={"SMAP\nWelcomeUiUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WelcomeUiUtils.kt\ncom/android/tools/idea/welcome/wizard/WelcomeUiUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,72:1\n2019#2,5:73\n*S KotlinDebug\n*F\n+ 1 WelcomeUiUtils.kt\ncom/android/tools/idea/welcome/wizard/WelcomeUiUtils\n*L\n30#1:73,5\n*E\n"})
public final class WelcomeUiUtils {
    @NotNull
    public static final String getSizeLabel(long size) {
        Storage.Unit element$iv;
        block2: {
            Storage.Unit[] $this$last$iv = Storage.Unit.values();
            boolean $i$f$last = false;
            int n = $this$last$iv.length + -1;
            if (0 <= n) {
                do {
                    int index$iv = n--;
                    Storage.Unit it = element$iv = $this$last$iv[index$iv];
                    boolean bl = false;
                    if (it.getNumberOfBytes() <= RangesKt.coerceAtLeast((long)size, (long)1L)) break block2;
                } while (0 <= n);
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        Storage.Unit unit = element$iv;
        double space = (double)size * 1.0 / (double)unit.getNumberOfBytes();
        String formatted = WelcomeUiUtils.roundToNumberOfDigits(space, 3);
        return formatted + " " + unit.getDisplayValue();
    }

    private static final String roundToNumberOfDigits(double number, int maxDigits) {
        NumberFormat numberFormat;
        int multiplier = 1;
        int digits = 0;
        digits = maxDigits;
        while (digits > 0 && number > (double)multiplier) {
            multiplier *= 10;
            int n = digits;
            digits = n + -1;
        }
        NumberFormat $this$roundToNumberOfDigits_u24lambda_u241 = numberFormat = NumberFormat.getNumberInstance();
        boolean bl = false;
        $this$roundToNumberOfDigits_u24lambda_u241.setGroupingUsed(false);
        $this$roundToNumberOfDigits_u24lambda_u241.setRoundingMode(RoundingMode.HALF_UP);
        $this$roundToNumberOfDigits_u24lambda_u241.setMaximumFractionDigits(digits);
        String string = numberFormat.format(number);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public static final String getMessageWithDetails(@NotNull String message, @Nullable String details) {
        String string;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CharSequence charSequence = details;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            string = message + ".";
        } else {
            String dotIfNeeded = StringsKt.endsWith$default((String)((Object)StringsKt.trim((CharSequence)details)).toString(), (String)".", (boolean)false, (int)2, null) ? "" : ".";
            string = message + ": " + details + dotIfNeeded;
        }
        return string;
    }

    public static final void invokeLater(@NotNull ModalityState modalityState, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ApplicationManager.getApplication().invokeLater(() -> WelcomeUiUtils.invokeLater$lambda$2(block), modalityState);
    }

    public static /* synthetic */ void invokeLater$default(ModalityState modalityState, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            ModalityState modalityState2 = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState2, (String)"defaultModalityState(...)");
            modalityState = modalityState2;
        }
        WelcomeUiUtils.invokeLater(modalityState, (Function0<Unit>)function0);
    }

    private static final void invokeLater$lambda$2(Function0 $tmp0) {
        $tmp0.invoke();
    }
}

