/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.io.CancellableFileIo;
import com.android.tools.idea.welcome.wizard.SdkComponentsStepUtils;
import com.android.tools.idea.welcome.wizard.WelcomeUiUtils;
import com.android.tools.sdk.AndroidSdkData;
import com.android.tools.sdk.AndroidSdkPath;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.UtilKt;
import java.io.File;
import java.nio.file.Path;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\b\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0014\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\f\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/welcome/wizard/SdkComponentsStepUtils;", "", "<init>", "()V", "getExistingParentFile", "Ljava/io/File;", "path", "", "getDiskSpace", "getTargetFilesystem", "isExistingSdk", "", "isNonEmptyNonSdk", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nSdkComponentsStepUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkComponentsStepUtils.kt\ncom/android/tools/idea/welcome/wizard/SdkComponentsStepUtils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n183#2,2:77\n1#3:79\n*S KotlinDebug\n*F\n+ 1 SdkComponentsStepUtils.kt\ncom/android/tools/idea/welcome/wizard/SdkComponentsStepUtils\n*L\n36#1:77,2\n*E\n"})
public final class SdkComponentsStepUtils {
    @NotNull
    public static final SdkComponentsStepUtils INSTANCE = new SdkComponentsStepUtils();

    private SdkComponentsStepUtils() {
    }

    @JvmStatic
    @Contract(value="null->null")
    @Nullable
    public static final File getExistingParentFile(@Nullable String path) {
        Object v0;
        block2: {
            CharSequence charSequence = path;
            if (charSequence == null || charSequence.length() == 0) {
                return null;
            }
            Sequence $this$firstOrNull$iv = SequencesKt.generateSequence((Object)new File(path).getAbsoluteFile(), SdkComponentsStepUtils::getExistingParentFile$lambda$0);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File p0 = (File)element$iv;
                boolean bl = false;
                if (!p0.exists()) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @JvmStatic
    @NotNull
    public static final String getDiskSpace(@Nullable String path) {
        Object object;
        File file = SdkComponentsStepUtils.getTargetFilesystem(path);
        if (file == null) {
            return "";
        }
        File file2 = file;
        String available = WelcomeUiUtils.getSizeLabel(file2.getFreeSpace());
        if (SystemInfo.isWindows) {
            String driveName2 = ((File)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)file2, (Function1)getDiskSpace.driveName.1.INSTANCE))).getName();
            object = available + " (drive " + driveName2 + ")";
        } else {
            object = available;
        }
        return object;
    }

    @JvmStatic
    @Nullable
    public static final File getTargetFilesystem(@Nullable String path) {
        File file = SdkComponentsStepUtils.getExistingParentFile(path);
        if (file == null) {
            File[] fileArray = File.listRoots();
            Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listRoots(...)");
            file = (File)ArraysKt.firstOrNull((Object[])fileArray);
        }
        return file;
    }

    @JvmStatic
    @Contract(value="null->false")
    public static final boolean isExistingSdk(@Nullable String path) {
        CharSequence charSequence = path;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        File $this$isExistingSdk_u24lambda_u241 = new File(path);
        boolean bl = false;
        return $this$isExistingSdk_u24lambda_u241.isDirectory() && AndroidSdkPath.isValid($this$isExistingSdk_u24lambda_u241);
    }

    @JvmStatic
    @Contract(value="null->false")
    public static final boolean isNonEmptyNonSdk(@Nullable String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.exists() && !UtilKt.isEmpty((Stream)UtilKt.notNullize((Stream)CancellableFileIo.list((Path)file.toPath()))) && AndroidSdkData.getSdkData(file) == null;
    }

    private static final File getExistingParentFile$lambda$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParentFile();
    }
}

