/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.tools.idea.avdmanager.HardwareAccelerationCheck;
import com.android.tools.idea.welcome.install.CheckSdkOperationKt;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.WizardException;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/welcome/install/CheckSdkOperation;", "Lcom/android/tools/idea/welcome/install/InstallOperation;", "Ljava/io/File;", "context", "Lcom/android/tools/idea/welcome/install/InstallContext;", "<init>", "(Lcom/android/tools/idea/welcome/install/InstallContext;)V", "perform", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "file", "cleanup", "", "result", "intellij.android.core"})
public final class CheckSdkOperation
extends InstallOperation<File, File> {
    public CheckSdkOperation(@NotNull InstallContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, 0.0);
    }

    @Override
    @NotNull
    protected File perform(@NotNull ProgressIndicator indicator, @NotNull File file) throws WizardException, InstallationCancelledException {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (HardwareAccelerationCheck.isChromeOSAndIsNotHWAccelerated()) {
            return file;
        }
        File tool = new File(file, "emulator" + File.separator + CheckSdkOperationKt.access$getTOOL_NAME$p());
        if (!tool.isFile()) {
            throw new WizardException("SDK emulator directory is missing");
        }
        if (!CheckSdkOperationKt.access$checkExecutePermission(tool)) {
            throw new WizardException(tool.getAbsolutePath() + " file is not a valid executable");
        }
        if (!CheckSdkOperationKt.access$checkRuns(tool)) {
            throw new WizardException(CheckSdkOperationKt.access$getERROR_CANT_RUN_TOOL$p());
        }
        return file;
    }

    @Override
    public void cleanup(@NotNull File result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
    }
}

