/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.annotations.concurrency.UiThread;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdCamera;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.avd.AvdManagerException;
import com.android.sdklib.internal.avd.AvdNames;
import com.android.sdklib.internal.avd.AvdNamesKt;
import com.android.sdklib.internal.avd.EmulatedProperties;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.sdklib.internal.avd.InternalSdCard;
import com.android.sdklib.internal.avd.OnDiskSkin;
import com.android.sdklib.internal.avd.SdCard;
import com.android.sdklib.internal.avd.Skin;
import com.android.sdklib.internal.avd.Skins;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.DeviceSkinUpdaterService;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.IdeAvdManagers;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableSdkComponentTreeNode;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.deprecated.InstallComponentsPath;
import com.google.wireless.android.sdk.stats.ProductDetails;
import com.google.wireless.android.sdk.stats.SetupWizardEvent;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.system.CpuArch;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001f\b\u0016\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0016\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0007J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010!\u001a\u00020\u0005H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/welcome/install/AndroidVirtualDeviceSdkComponentTreeNode;", "Lcom/android/tools/idea/welcome/install/InstallableSdkComponentTreeNode;", "androidVersion", "Lcom/android/sdklib/AndroidVersion;", "installUpdates", "", "<init>", "(Lcom/android/sdklib/AndroidVersion;Z)V", "remotePackages", "", "Lcom/android/repository/api/RemotePackage;", "(Ljava/util/Collection;Z)V", "IS_ARM64_HOST_OS", "MAX_X86_API_LEVEL", "", "getSystemImageDescription", "Lcom/android/tools/idea/avdmanager/SystemImageDescription;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "isAvdCreationNeeded", "createAvd", "Lcom/android/sdklib/internal/avd/AvdInfo;", "maxCpuCores", "getRequiredSysimgPath", "", "isArm64HostOs", "requiredSdkPackages", "getRequiredSdkPackages", "()Ljava/util/Collection;", "configure", "", "installContext", "Lcom/android/tools/idea/welcome/install/InstallContext;", "isSelectedByDefault", "sdkComponentsMetricKind", "Lcom/google/wireless/android/sdk/stats/SetupWizardEvent$SdkInstallationMetrics$SdkComponentKind;", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAndroidVirtualDeviceSdkComponentTreeNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidVirtualDeviceSdkComponentTreeNode.kt\ncom/android/tools/idea/welcome/install/AndroidVirtualDeviceSdkComponentTreeNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n1#2:264\n*E\n"})
public final class AndroidVirtualDeviceSdkComponentTreeNode
extends InstallableSdkComponentTreeNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final AndroidVersion androidVersion;
    private final boolean IS_ARM64_HOST_OS;
    private final int MAX_X86_API_LEVEL;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String DEFAULT_DEVICE_ID = "medium_phone";
    private static final IdDisplay ID_ADDON_GOOGLE_API_IMG;
    private static final IdDisplay ID_VENDOR_GOOGLE;
    @NotNull
    private static final Storage DEFAULT_RAM_SIZE;
    @NotNull
    private static final Storage DEFAULT_HEAP_SIZE;

    public AndroidVirtualDeviceSdkComponentTreeNode(@Nullable AndroidVersion androidVersion, boolean installUpdates) {
        super("Android Virtual Device", "A preconfigured and optimized Android Virtual Device for app testing on the emulator. (Recommended)", installUpdates);
        this.androidVersion = androidVersion;
        this.IS_ARM64_HOST_OS = CpuArch.isArm64() || CommonMetricsData.getOsArchitecture() == ProductDetails.CpuArchitecture.X86_ON_ARM;
        this.MAX_X86_API_LEVEL = 30;
    }

    /*
     * WARNING - void declaration
     */
    public AndroidVirtualDeviceSdkComponentTreeNode(@NotNull Collection<? extends RemotePackage> remotePackages, boolean installUpdates) {
        AndroidVersion androidVersion;
        Intrinsics.checkNotNullParameter(remotePackages, (String)"remotePackages");
        AndroidVirtualDeviceSdkComponentTreeNode androidVirtualDeviceSdkComponentTreeNode = this;
        RemotePackage remotePackage = InstallComponentsPath.findLatestPlatform(remotePackages, true);
        if (remotePackage != null) {
            void it;
            RemotePackage remotePackage2 = remotePackage;
            AndroidVirtualDeviceSdkComponentTreeNode androidVirtualDeviceSdkComponentTreeNode2 = androidVirtualDeviceSdkComponentTreeNode;
            boolean bl = false;
            TypeDetails typeDetails = it.getTypeDetails();
            Intrinsics.checkNotNull((Object)typeDetails, (String)"null cannot be cast to non-null type com.android.sdklib.repository.meta.DetailsTypes.PlatformDetailsType");
            androidVersion = ((DetailsTypes.PlatformDetailsType)typeDetails).getAndroidVersion();
            androidVirtualDeviceSdkComponentTreeNode = androidVirtualDeviceSdkComponentTreeNode2;
        } else {
            androidVersion = null;
        }
        androidVirtualDeviceSdkComponentTreeNode(androidVersion, installUpdates);
    }

    private final SystemImageDescription getSystemImageDescription(AndroidSdkHandler sdkHandler) throws WizardException {
        StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(this.getClass());
        if (this.androidVersion == null) {
            throw new WizardException("Missing system image required for an AVD setup");
        }
        Collection systemImages = sdkHandler.getSystemImageManager((ProgressIndicator)progress2).lookup(ID_ADDON_GOOGLE_API_IMG, this.androidVersion, ID_VENDOR_GOOGLE);
        if (systemImages.isEmpty()) {
            throw new WizardException("Missing system image required for an AVD setup");
        }
        return new SystemImageDescription((ISystemImage)systemImages.iterator().next());
    }

    @UiThread
    public final boolean isAvdCreationNeeded(@NotNull AndroidSdkHandler sdkHandler) {
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        AvdManagerConnection avdManager = AvdManagerConnection.Companion.getAvdManagerConnection(sdkHandler);
        Ref.BooleanRef shouldCreateAvd = new Ref.BooleanRef();
        shouldCreateAvd.element = true;
        try {
            ModalTaskOwner modalTaskOwner = ModalTaskOwner.guess();
            Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"guess(...)");
            TasksKt.runWithModalProgressBlocking((ModalTaskOwner)modalTaskOwner, (String)"Checking for existing Android Virtual Devices", (TaskCancellation)((TaskCancellation)TaskCancellation.Companion.cancellable()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(shouldCreateAvd, avdManager, null){
                int label;
                final /* synthetic */ Ref.BooleanRef $shouldCreateAvd;
                final /* synthetic */ AvdManagerConnection $avdManager;
                {
                    this.$shouldCreateAvd = $shouldCreateAvd;
                    this.$avdManager = $avdManager;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$shouldCreateAvd, this.$avdManager, null){
                                int label;
                                final /* synthetic */ Ref.BooleanRef $shouldCreateAvd;
                                final /* synthetic */ AvdManagerConnection $avdManager;
                                {
                                    this.$shouldCreateAvd = $shouldCreateAvd;
                                    this.$avdManager = $avdManager;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.$shouldCreateAvd.element = this.$avdManager.getAvds(true).isEmpty();
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        catch (ProcessCanceledException e) {
            shouldCreateAvd.element = true;
        }
        return shouldCreateAvd.element;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final AvdInfo createAvd(@NotNull AndroidSdkHandler sdkHandler) throws WizardException {
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        avdManager = IdeAvdManagers.INSTANCE.getAvdManager(sdkHandler);
        v0 = sdkHandler.getLocation();
        Intrinsics.checkNotNull((Object)v0);
        device = com.android.tools.idea.welcome.install.AndroidVirtualDeviceSdkComponentTreeNode$Companion.access$getDevice(AndroidVirtualDeviceSdkComponentTreeNode.Companion, v0);
        systemImageDescription = this.getSystemImageDescription(sdkHandler);
        $this$createAvd_u24lambda_u243 = avdBuilder = avdManager.createAvdBuilder(device);
        $i$a$-with-AndroidVirtualDeviceSdkComponentTreeNode$createAvd$1 = false;
        v1 = systemImageDescription.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getVersion(...)");
        $this$createAvd_u24lambda_u243.setDisplayName(AvdNamesKt.uniquifyDisplayName((AvdManager)avdManager, (String)AvdNames.getDefaultDeviceDisplayName((Device)device, (AndroidVersion)v1)));
        $this$createAvd_u24lambda_u243.setAvdName(AvdNamesKt.uniquifyAvdName((AvdManager)avdManager, (String)AvdNames.cleanAvdName((String)$this$createAvd_u24lambda_u243.getDisplayName())));
        $this$createAvd_u24lambda_u243.setSystemImage(systemImageDescription.getSystemImage());
        $this$createAvd_u24lambda_u243.setSdCard((SdCard)new InternalSdCard(EmulatedProperties.DEFAULT_SDCARD_SIZE.getSize()));
        v2 = $this$createAvd_u24lambda_u243;
        var8_8 = device.getDefaultHardware().getSkinFile();
        if (var8_8 == null) ** GOTO lbl-1000
        var9_9 = var8_8;
        var10_11 = v2;
        $i$a$-let-AndroidVirtualDeviceSdkComponentTreeNode$createAvd$1$1 = false;
        v2 = var10_11;
        var12_14 = sdkHandler.toCompatiblePath((File)it);
        if (var12_14 != null) {
            $i$a$-let-AndroidVirtualDeviceSdkComponentTreeNode$createAvd$1$1 = var12_14;
            var10_11 = v2;
            $i$a$-let-AndroidVirtualDeviceSdkComponentTreeNode$createAvd$1$2 = false;
            v3 = DeviceSkinUpdaterService.getInstance().updateSkins((Path)defaultHardwareSkin, systemImageDescription).get();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"get(...)");
            v2 = var10_11;
            v4 = (Skin)new OnDiskSkin((Path)v3);
        } else lbl-1000:
        // 2 sources

        {
            v4 = Skins.defaultGenericSkin((Device)device);
        }
        v2.setSkin(v4);
        $this$createAvd_u24lambda_u243.setGpuMode(GpuMode.AUTO);
        $this$createAvd_u24lambda_u243.setBackCamera(AvdCamera.VIRTUAL_SCENE);
        $this$createAvd_u24lambda_u243.setFrontCamera(AvdCamera.EMULATED);
        $this$createAvd_u24lambda_u243.setEnableKeyboard(true);
        v5 = EmulatedProperties.DEFAULT_NETWORK_LATENCY;
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"DEFAULT_NETWORK_LATENCY");
        $this$createAvd_u24lambda_u243.setNetworkLatency(v5);
        v6 = EmulatedProperties.DEFAULT_NETWORK_SPEED;
        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"DEFAULT_NETWORK_SPEED");
        $this$createAvd_u24lambda_u243.setNetworkSpeed(v6);
        $this$createAvd_u24lambda_u243.setRam(AndroidVirtualDeviceSdkComponentTreeNode.DEFAULT_RAM_SIZE);
        v7 = EmulatedProperties.defaultInternalStorage((Device)device);
        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"defaultInternalStorage(...)");
        $this$createAvd_u24lambda_u243.setInternalStorage(v7);
        $this$createAvd_u24lambda_u243.setVmHeap(AndroidVirtualDeviceSdkComponentTreeNode.DEFAULT_HEAP_SIZE);
        abi = Abi.getEnum((String)systemImageDescription.getPrimaryAbiType());
        supportsSmp = abi != null && abi.supportsMultipleCpuCores() != false && this.maxCpuCores() > 1;
        avdBuilder.setCpuCoreCount(supportsSmp != false ? this.maxCpuCores() : 1);
        try {
            return avdManager.createAvd(avdBuilder);
        }
        catch (AvdManagerException e) {
            v8 = e.getMessage();
            if (v8 == null) {
                v8 = "Unable to create AVD";
            }
            throw new WizardException(v8, e);
        }
    }

    private final int maxCpuCores() {
        return Runtime.getRuntime().availableProcessors() / 2;
    }

    @VisibleForTesting
    @NotNull
    public final String getRequiredSysimgPath(boolean isArm64HostOs) {
        String string = DetailsTypes.getSysImgPath((IdDisplay)ID_VENDOR_GOOGLE, (AndroidVersion)this.androidVersion, (IdDisplay)ID_ADDON_GOOGLE_API_IMG, (String)(isArm64HostOs ? "arm64-v8a" : (this.androidVersion == null ? "x86" : (this.androidVersion.compareTo(new AndroidVersion(this.MAX_X86_API_LEVEL)) > 0 ? "x86_64" : "x86"))));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSysImgPath(...)");
        return string;
    }

    @Override
    @NotNull
    protected Collection<String> getRequiredSdkPackages() {
        return this.androidVersion == null ? (Collection)CollectionsKt.emptyList() : (Collection)CollectionsKt.listOf((Object)this.getRequiredSysimgPath(this.IS_ARM64_HOST_OS));
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
        Intrinsics.checkNotNullParameter((Object)installContext, (String)"installContext");
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        try {
            installContext.getProgressIndicator().setIndeterminate(true);
            installContext.getProgressIndicator().setText("Creating Android virtual device");
            installContext.print("Creating Android virtual device\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            AvdInfo avd = this.createAvd(sdkHandler);
            String successMessage = "Android virtual device " + avd.getName() + " was successfully created\n";
            installContext.print(successMessage, ConsoleViewContentType.SYSTEM_OUTPUT);
        }
        catch (WizardException e) {
            LOG.error((Throwable)e);
            String failureMessage = "Unable to create a virtual device: " + e.getMessage() + "\n";
            installContext.print(failureMessage, ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    @Override
    public boolean isSelectedByDefault() {
        SystemImageDescription systemImageDescription;
        AndroidSdkHandler androidSdkHandler = this.sdkHandler;
        if (androidSdkHandler == null) {
            return false;
        }
        AndroidSdkHandler sdkHandler = androidSdkHandler;
        try {
            systemImageDescription = this.getSystemImageDescription(sdkHandler);
        }
        catch (WizardException e) {
            return true;
        }
        SystemImageDescription desired = systemImageDescription;
        AvdManagerConnection connection2 = AvdManagerConnection.Companion.getAvdManagerConnection(sdkHandler);
        List<AvdInfo> avds2 = connection2.getAvds(false);
        for (AvdInfo avd : avds2) {
            if (!Intrinsics.areEqual((Object)avd.getAbiType(), (Object)desired.getPrimaryAbiType()) || !Intrinsics.areEqual((Object)avd.getAndroidVersion(), (Object)desired.getVersion())) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public SetupWizardEvent.SdkInstallationMetrics.SdkComponentKind sdkComponentsMetricKind() {
        return SetupWizardEvent.SdkInstallationMetrics.SdkComponentKind.ANDROID_VIRTUAL_DEVICE;
    }

    static {
        Logger logger = Logger.getInstance(AndroidVirtualDeviceSdkComponentTreeNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        ID_ADDON_GOOGLE_API_IMG = IdDisplay.create((String)"google_apis_playstore", (String)"Google Play");
        ID_VENDOR_GOOGLE = IdDisplay.create((String)"google", (String)"Google LLC");
        DEFAULT_RAM_SIZE = new Storage(2L, Storage.Unit.GiB);
        DEFAULT_HEAP_SIZE = new Storage(336L, Storage.Unit.MiB);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/welcome/install/AndroidVirtualDeviceSdkComponentTreeNode$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "DEFAULT_DEVICE_ID", "", "ID_ADDON_GOOGLE_API_IMG", "Lcom/android/sdklib/repository/IdDisplay;", "kotlin.jvm.PlatformType", "ID_VENDOR_GOOGLE", "DEFAULT_RAM_SIZE", "Lcom/android/sdklib/devices/Storage;", "DEFAULT_HEAP_SIZE", "getDevice", "Lcom/android/sdklib/devices/Device;", "sdkPath", "Ljava/nio/file/Path;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private final Device getDevice(Path sdkPath) throws WizardException {
            Object v1;
            block2: {
                Collection<Device> collection2 = DeviceManagerConnection.getDeviceManagerConnection(sdkPath).getDevices();
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"getDevices(...)");
                Iterable iterable = collection2;
                for (Object t : iterable) {
                    Device it = (Device)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)AndroidVirtualDeviceSdkComponentTreeNode.DEFAULT_DEVICE_ID)) continue;
                    v1 = t;
                    break block2;
                }
                v1 = null;
            }
            Device device2 = v1;
            if (device2 == null) {
                throw new WizardException("No device definition with \"medium_phone\" ID found");
            }
            return device2;
        }

        public static final /* synthetic */ Device access$getDevice(Companion $this, Path sdkPath) {
            return $this.getDevice(sdkPath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

