/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.android.ide.common.util.PathString;
import com.android.tools.idea.util.FileExtensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H$J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\rH$J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\rH$J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J+\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00170\u001cH\u0082\bJ\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010 \u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010 \u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010 \u001a\u00020$H\u0016J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010 \u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010 \u001a\u00020$H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007RZ\u0010\b\u001aN\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*%\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\u000f\u00a2\u0006\u0002\b\u000b0\t\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/tools/idea/util/PoliteAndroidVirtualFileListener;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "relevantPendingFilesToFacet", "", "Lcom/android/ide/common/util/PathString;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/android/facet/AndroidFacet;", "kotlin.jvm.PlatformType", "", "isPossiblyRelevant", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isRelevant", "facet", "fileChanged", "", "path", "possiblyIrrelevantFileChanged", "runIfRelevant", "block", "Lkotlin/Function2;", "possiblyIrrelevantFileChangePending", "pendingPossiblyIrrelevantFileChangeComplete", "beforeFileMovement", "event", "Lcom/intellij/openapi/vfs/VirtualFileMoveEvent;", "fileMoved", "beforeFileDeletion", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "fileDeleted", "contentsChanged", "propertyChanged", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "fileCreated", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nPoliteAndroidVirtualFileListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoliteAndroidVirtualFileListener.kt\ncom/android/tools/idea/util/PoliteAndroidVirtualFileListener\n*L\n1#1,128:1\n91#1,6:129\n91#1,6:135\n*S KotlinDebug\n*F\n+ 1 PoliteAndroidVirtualFileListener.kt\ncom/android/tools/idea/util/PoliteAndroidVirtualFileListener\n*L\n88#1:129,6\n99#1:135,6\n*E\n"})
public abstract class PoliteAndroidVirtualFileListener
implements VirtualFileListener {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<PathString, AndroidFacet> relevantPendingFilesToFacet;

    public PoliteAndroidVirtualFileListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Map map2 = ContainerUtil.createWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createWeakValueMap(...)");
        this.relevantPendingFilesToFacet = map2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    protected abstract boolean isPossiblyRelevant(@NotNull VirtualFile var1);

    protected abstract boolean isRelevant(@NotNull VirtualFile var1, @NotNull AndroidFacet var2);

    protected abstract void fileChanged(@NotNull PathString var1, @NotNull AndroidFacet var2);

    /*
     * WARNING - void declaration
     */
    protected final void possiblyIrrelevantFileChanged(@NotNull VirtualFile file) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PoliteAndroidVirtualFileListener politeAndroidVirtualFileListener = this;
        VirtualFile file$iv = file;
        boolean $i$f$runIfRelevant = false;
        if (file$iv.isValid() && this_$iv.isPossiblyRelevant(file$iv)) {
            AndroidFacet facet$iv;
            AndroidFacet androidFacet = AndroidFacet.getInstance((VirtualFile)file$iv, (Project)this_$iv.project);
            if (androidFacet != null && this_$iv.isRelevant(file$iv, facet$iv = androidFacet)) {
                void p1;
                AndroidFacet androidFacet2 = facet$iv;
                PathString p0 = FileExtensions.toPathString(file$iv);
                boolean bl = false;
                this.fileChanged(p0, (AndroidFacet)p1);
            }
        }
    }

    private final void runIfRelevant(VirtualFile file, Function2<? super PathString, ? super AndroidFacet, Unit> block) {
        boolean $i$f$runIfRelevant = false;
        if (!file.isValid() || !this.isPossiblyRelevant(file)) {
            return;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((VirtualFile)file, (Project)this.project);
        if (androidFacet == null) {
            return;
        }
        AndroidFacet facet = androidFacet;
        if (this.isRelevant(file, facet)) {
            block.invoke((Object)FileExtensions.toPathString(file), (Object)facet);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void possiblyIrrelevantFileChangePending(VirtualFile file) {
        void this_$iv;
        PoliteAndroidVirtualFileListener politeAndroidVirtualFileListener = this;
        VirtualFile file$iv = file;
        boolean $i$f$runIfRelevant = false;
        if (file$iv.isValid() && this_$iv.isPossiblyRelevant(file$iv)) {
            AndroidFacet facet$iv;
            AndroidFacet androidFacet = AndroidFacet.getInstance((VirtualFile)file$iv, (Project)this_$iv.project);
            if (androidFacet != null && this_$iv.isRelevant(file$iv, facet$iv = androidFacet)) {
                void facet;
                AndroidFacet androidFacet2 = facet$iv;
                PathString path = FileExtensions.toPathString(file$iv);
                boolean bl = false;
                this.relevantPendingFilesToFacet.put(path, (AndroidFacet)facet);
            }
        }
    }

    private final void pendingPossiblyIrrelevantFileChangeComplete(PathString path) {
        block0: {
            AndroidFacet androidFacet = this.relevantPendingFilesToFacet.remove(path);
            if (androidFacet == null) break block0;
            AndroidFacet facet = androidFacet;
            boolean bl = false;
            this.fileChanged(path, facet);
        }
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.possiblyIrrelevantFileChangePending(virtualFile);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = event.getOldParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getOldParent(...)");
        PathString pathString = FileExtensions.toPathString(virtualFile);
        String string = event.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        this.pendingPossiblyIrrelevantFileChangeComplete(pathString.resolve(string));
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        this.possiblyIrrelevantFileChanged(virtualFile2);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.possiblyIrrelevantFileChangePending(virtualFile);
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.pendingPossiblyIrrelevantFileChangeComplete(FileExtensions.toPathString(virtualFile));
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.possiblyIrrelevantFileChanged(virtualFile);
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.possiblyIrrelevantFileChanged(virtualFile);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.possiblyIrrelevantFileChanged(virtualFile);
    }
}

