/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenshot;

import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.resources.ScreenRound;
import com.android.sdklib.deviceprovisioner.DeviceType;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.adtui.device.DeviceArtDescriptor;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.SkinUtils;
import com.android.tools.idea.ui.AndroidAdbUiBundle;
import com.android.tools.idea.ui.screenshot.DeviceFramingOption;
import com.android.tools.idea.ui.screenshot.DeviceScreenshotDecorator;
import com.android.tools.idea.ui.screenshot.FramingOption;
import com.android.tools.idea.ui.screenshot.ScreenshotDecorator;
import com.android.tools.idea.ui.screenshot.ScreenshotImage;
import com.android.tools.sdk.DeviceManagers;
import com.intellij.openapi.actionSystem.DataKey;
import java.awt.Dimension;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 =2\u00020\u0001:\u0002<=B+\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\t\u0010\u000fB#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\u0011B-\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\u0004\b\t\u0010\u0014J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020\u001dJ$\u0010(\u001a\b\u0012\u0004\u0012\u00020)0#2\u0006\u0010%\u001a\u00020&2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0002J*\u0010-\u001a\u00020.*\b\u0012\u0004\u0012\u00020)0/2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u000203H\u0002J\f\u00104\u001a\u000205*\u00020,H\u0002J\f\u00106\u001a\u000205*\u00020,H\u0002J\f\u00107\u001a\u000205*\u00020,H\u0002J\f\u00108\u001a\u000205*\u00020,H\u0002J\f\u00109\u001a\u000205*\u00020,H\u0002J\f\u0010:\u001a\u000205*\u00020;H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006>"}, d2={"Lcom/android/tools/idea/ui/screenshot/ScreenshotParameters;", "", "serialNumber", "", "deviceType", "Lcom/android/sdklib/deviceprovisioner/DeviceType;", "deviceName", "framingOption", "Lcom/android/tools/idea/ui/screenshot/DeviceFramingOption;", "<init>", "(Ljava/lang/String;Lcom/android/sdklib/deviceprovisioner/DeviceType;Ljava/lang/String;Lcom/android/tools/idea/ui/screenshot/DeviceFramingOption;)V", "avdFolder", "Ljava/nio/file/Path;", "avdManagerConnection", "Lcom/android/tools/idea/avdmanager/AvdManagerConnection;", "(Ljava/lang/String;Lcom/android/sdklib/deviceprovisioner/DeviceType;Ljava/nio/file/Path;Lcom/android/tools/idea/avdmanager/AvdManagerConnection;)V", "deviceModel", "(Ljava/lang/String;Lcom/android/sdklib/deviceprovisioner/DeviceType;Ljava/lang/String;)V", "properties", "", "(Ljava/lang/String;Lcom/android/sdklib/deviceprovisioner/DeviceType;Ljava/util/Map;)V", "getSerialNumber", "()Ljava/lang/String;", "getDeviceType", "()Lcom/android/sdklib/deviceprovisioner/DeviceType;", "getDeviceName", "getFramingOption", "()Lcom/android/tools/idea/ui/screenshot/DeviceFramingOption;", "defaultFrameIndex", "", "screenshotDecorator", "Lcom/android/tools/idea/ui/screenshot/ScreenshotDecorator;", "getScreenshotDecorator", "()Lcom/android/tools/idea/ui/screenshot/ScreenshotDecorator;", "getFramingOptions", "", "Lcom/android/tools/idea/ui/screenshot/FramingOption;", "screenshotImage", "Lcom/android/tools/idea/ui/screenshot/ScreenshotImage;", "getDefaultFramingOption", "findMatchingSkins", "Lcom/android/tools/idea/ui/screenshot/ScreenshotParameters$MatchingSkin;", "devices", "", "Lcom/android/sdklib/devices/Device;", "addMatch", "", "", "displayName", "skinFolder", "matchDistance", "", "isAutomotive", "", "isTv", "isWatch", "isXrHeadset", "isTablet", "isRound", "Lcom/android/sdklib/devices/Screen;", "MatchingSkin", "Companion", "intellij.android.adb.ui"})
@SourceDebugExtension(value={"SMAP\nScreenshotParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotParameters.kt\ncom/android/tools/idea/ui/screenshot/ScreenshotParameters\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n1011#2,2:282\n360#2,7:284\n1208#2,2:291\n1236#2,4:293\n1#3:297\n*S KotlinDebug\n*F\n+ 1 ScreenshotParameters.kt\ncom/android/tools/idea/ui/screenshot/ScreenshotParameters\n*L\n102#1:282,2\n103#1:284,7\n107#1:291,2\n107#1:293,4\n*E\n"})
public final class ScreenshotParameters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String serialNumber;
    @NotNull
    private final DeviceType deviceType;
    @NotNull
    private final String deviceName;
    @Nullable
    private final DeviceFramingOption framingOption;
    private int defaultFrameIndex;
    @NotNull
    private final ScreenshotDecorator screenshotDecorator;
    @NotNull
    private static final DataKey<ScreenshotParameters> DATA_KEY = DataKey.Companion.create("ScreenshotParameters");
    @Nullable
    private static final Path skinHome;

    private ScreenshotParameters(String serialNumber, DeviceType deviceType, String deviceName, DeviceFramingOption framingOption) {
        this.serialNumber = serialNumber;
        this.deviceType = deviceType;
        this.deviceName = deviceName;
        this.framingOption = framingOption;
        this.screenshotDecorator = new DeviceScreenshotDecorator();
    }

    @NotNull
    public final String getSerialNumber() {
        return this.serialNumber;
    }

    @NotNull
    public final DeviceType getDeviceType() {
        return this.deviceType;
    }

    @NotNull
    public final String getDeviceName() {
        return this.deviceName;
    }

    @Nullable
    public final DeviceFramingOption getFramingOption() {
        return this.framingOption;
    }

    @NotNull
    public final ScreenshotDecorator getScreenshotDecorator() {
        return this.screenshotDecorator;
    }

    public ScreenshotParameters(@NotNull String serialNumber, @NotNull DeviceType deviceType, @NotNull Path avdFolder, @NotNull AvdManagerConnection avdManagerConnection) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        Intrinsics.checkNotNullParameter((Object)avdFolder, (String)"avdFolder");
        Intrinsics.checkNotNullParameter((Object)avdManagerConnection, (String)"avdManagerConnection");
        this(serialNumber, deviceType, ScreenshotParameters.Companion.getAvdProperties(avdFolder, avdManagerConnection));
    }

    public /* synthetic */ ScreenshotParameters(String string, DeviceType deviceType, Path path, AvdManagerConnection avdManagerConnection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            avdManagerConnection = AvdManagerConnection.Companion.getDefaultAvdManagerConnection();
        }
        this(string, deviceType, path, avdManagerConnection);
    }

    public ScreenshotParameters(@NotNull String serialNumber, @NotNull DeviceType deviceType, @Nullable String deviceModel) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        String string = deviceModel;
        if (string == null) {
            string = "Unknown";
        }
        this(serialNumber, deviceType, string, ScreenshotParameters.Companion.framingOptionFromModel(deviceModel));
    }

    private ScreenshotParameters(String serialNumber, DeviceType deviceType, Map<String, String> properties) {
        this(serialNumber, deviceType, ScreenshotParameters.Companion.getDeviceName(properties), ScreenshotParameters.Companion.getFramingOption(properties));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FramingOption> getFramingOptions(@NotNull ScreenshotImage screenshotImage) {
        List framingOptions;
        block9: {
            void $this$associateByTo$iv$iv;
            Iterable<Object> item$iv2;
            Object object;
            Intrinsics.checkNotNullParameter((Object)screenshotImage, (String)"screenshotImage");
            if (this.framingOption != null) {
                return CollectionsKt.listOf((Object)this.framingOption);
            }
            framingOptions = new ArrayList();
            List<MatchingSkin> matchingSkins = this.findMatchingSkins(screenshotImage, ScreenshotParameters.Companion.getDevices());
            if (!((Collection)matchingSkins).isEmpty()) {
                int n;
                int n2;
                block8: {
                    void $this$indexOfFirst$iv;
                    MatchingSkin bestMatch = matchingSkins.get(0);
                    for (MatchingSkin skin : matchingSkins) {
                        framingOptions.add(new DeviceFramingOption(skin.getDisplayName(), skin.getSkinFolder()));
                    }
                    List $this$sortBy$iv = framingOptions;
                    boolean $i$f$sortBy = false;
                    if ($this$sortBy$iv.size() > 1) {
                        CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                DeviceFramingOption it = (DeviceFramingOption)a;
                                boolean bl = false;
                                Comparable comparable = (Comparable)((Object)it.getDisplayName());
                                it = (DeviceFramingOption)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getDisplayName())));
                            }
                        });
                    }
                    $this$sortBy$iv = framingOptions;
                    object = this;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Iterable<Object> item$iv2 : $this$indexOfFirst$iv) {
                        DeviceFramingOption it = (DeviceFramingOption)((Object)item$iv2);
                        boolean bl = false;
                        if (Intrinsics.areEqual((Object)it.getSkinFolder(), (Object)bestMatch.getSkinFolder())) {
                            n2 = index$iv;
                            break block8;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                ((ScreenshotParameters)object).defaultFrameIndex = n = n2;
            }
            if (this.deviceType != DeviceType.HANDHELD && this.deviceType != DeviceType.AUTOMOTIVE) break block9;
            Dimension displaySize = screenshotImage.getDisplaySize();
            List list = DeviceArtDescriptor.getDescriptors(null);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDescriptors(...)");
            Iterable $this$associateBy$iv = list;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            item$iv2 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                DeviceArtDescriptor deviceArtDescriptor = (DeviceArtDescriptor)element$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.put(it.getId(), element$iv$iv);
            }
            Map descriptors = destination$iv$iv;
            int displayDensity = screenshotImage.getDisplayDensity();
            double diagonalSizeInches = displayDensity == 0 ? Double.NaN : Math.hypot(displaySize.width, displaySize.height) / (double)displayDensity;
            String deviceArtId = this.deviceType == DeviceType.HANDHELD && (Double.isNaN(diagonalSizeInches) || diagonalSizeInches < 7.0) ? "phone" : "tablet";
            DeviceArtDescriptor deviceArtDescriptor = (DeviceArtDescriptor)descriptors.get(deviceArtId);
            if (deviceArtDescriptor != null) {
                DeviceArtDescriptor it = deviceArtDescriptor;
                boolean bl = false;
                framingOptions.add(new DeviceFramingOption(it));
            }
        }
        return framingOptions;
    }

    public final int getDefaultFramingOption() {
        return this.defaultFrameIndex;
    }

    private final List<MatchingSkin> findMatchingSkins(ScreenshotImage screenshotImage, Collection<Device> devices2) {
        Dimension displaySize = screenshotImage.getDisplaySize();
        double w = displaySize.width;
        double h = displaySize.height;
        double diagonalSize = Math.hypot(w, h);
        double diagonalSizeInches = diagonalSize / (double)screenshotImage.getDisplayDensity();
        double aspectRatio = h / w;
        List matches = new ArrayList();
        for (Device device2 : devices2) {
            Path skinFolder;
            if (device2.getIsDeprecated() || this.isAutomotive(device2) != (screenshotImage.getDeviceType() == DeviceType.AUTOMOTIVE) || this.isTv(device2) != (screenshotImage.getDeviceType() == DeviceType.TV) || this.isWatch(device2) != (screenshotImage.getDeviceType() == DeviceType.WEAR) || this.isXrHeadset(device2) != (screenshotImage.getDeviceType() == DeviceType.XR_HEADSET) || this.isTablet(device2) != (screenshotImage.getDeviceType() == DeviceType.HANDHELD && diagonalSizeInches >= 7.0)) continue;
            Screen screen = device2.getDefaultHardware().getScreen();
            Intrinsics.checkNotNull((Object)screen);
            if (this.isRound(screen) != screenshotImage.isRoundDisplay() || ScreenshotParameters.Companion.getSkinFolder(device2) == null) continue;
            int width = screen.getXDimension();
            int height = screen.getYDimension();
            double deviceDiagonal = Math.hypot(width, height);
            double deviceAspectRatio = (double)height / (double)width;
            double sizeDifference = Math.abs(MathKt.log2((double)(deviceDiagonal / diagonalSize)));
            double aspectRatioDifference = Math.abs(MathKt.log2((double)(deviceAspectRatio / aspectRatio)));
            if (!(aspectRatioDifference <= 0.1)) continue;
            double distance = Math.hypot(sizeDifference, aspectRatioDifference);
            String string = device2.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            this.addMatch(matches, string, skinFolder, distance);
        }
        return matches;
    }

    private final void addMatch(List<MatchingSkin> $this$addMatch, String displayName, Path skinFolder, double matchDistance) {
        int i;
        if (!((Collection)$this$addMatch).isEmpty()) {
            if (matchDistance > $this$addMatch.get(0).getMatchDistance() * 2.0) {
                return;
            }
            int n = ((Collection)$this$addMatch).size() + -1;
            if (0 <= n) {
                int i2;
                while (!($this$addMatch.get(i2 = n--).getMatchDistance() <= matchDistance * 2.0)) {
                    $this$addMatch.remove(i2);
                    if (0 <= n) continue;
                }
            }
        }
        for (i = 0; i < $this$addMatch.size() && !(matchDistance < $this$addMatch.get(i).getMatchDistance()); ++i) {
        }
        $this$addMatch.add(i, new MatchingSkin(displayName, skinFolder, matchDistance));
    }

    private final boolean isAutomotive(Device $this$isAutomotive) {
        String string = $this$isAutomotive.getTagId();
        return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"automotive", (boolean)false, (int)2, null) : false;
    }

    private final boolean isTv(Device $this$isTv) {
        String string = $this$isTv.getTagId();
        return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"android-tv", (boolean)false, (int)2, null) : false;
    }

    private final boolean isWatch(Device $this$isWatch) {
        String string = $this$isWatch.getTagId();
        return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"wear", (boolean)false, (int)2, null) : false;
    }

    private final boolean isXrHeadset(Device $this$isXrHeadset) {
        String string = $this$isXrHeadset.getTagId();
        return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"android-xr", (boolean)false, (int)2, null) : false;
    }

    private final boolean isTablet(Device $this$isTablet) {
        if (this.isAutomotive($this$isTablet) || this.isTv($this$isTablet) || this.isWatch($this$isTablet) || this.isXrHeadset($this$isTablet)) {
            return false;
        }
        Screen screen = $this$isTablet.getDefaultHardware().getScreen();
        return Math.hypot((double)screen.getXDimension() / screen.getXdpi(), (double)screen.getYDimension() / screen.getYdpi()) >= 7.0;
    }

    private final boolean isRound(Screen $this$isRound) {
        return $this$isRound.getScreenRound() == ScreenRound.ROUND;
    }

    static {
        File file = DeviceArtDescriptor.getBundledDescriptorsFolder();
        skinHome = file != null ? file.toPath() : null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000b*\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u000bH\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0018\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u0004\u0018\u00010\r*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/ui/screenshot/ScreenshotParameters$Companion;", "", "<init>", "()V", "DATA_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/android/tools/idea/ui/screenshot/ScreenshotParameters;", "getDATA_KEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "getAvdProperties", "", "", "avdFolder", "Ljava/nio/file/Path;", "avdManagerConnection", "Lcom/android/tools/idea/avdmanager/AvdManagerConnection;", "getDeviceName", "getFramingOption", "Lcom/android/tools/idea/ui/screenshot/DeviceFramingOption;", "framingOptionFromModel", "deviceModel", "getDevices", "", "Lcom/android/sdklib/devices/Device;", "skinHome", "skinFolder", "getSkinFolder", "(Lcom/android/sdklib/devices/Device;)Ljava/nio/file/Path;", "intellij.android.adb.ui"})
    @SourceDebugExtension(value={"SMAP\nScreenshotParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotParameters.kt\ncom/android/tools/idea/ui/screenshot/ScreenshotParameters$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n1#2:282\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<ScreenshotParameters> getDATA_KEY() {
            return DATA_KEY;
        }

        private final Map<String, String> getAvdProperties(Path avdFolder, AvdManagerConnection avdManagerConnection) {
            Object object = avdManagerConnection.findAvdWithFolder(avdFolder);
            if (object == null || (object = object.getProperties()) == null) {
                object = MapsKt.emptyMap();
            }
            return object;
        }

        private final String getDeviceName(Map<String, String> $this$getDeviceName) {
            return $this$getDeviceName.getOrDefault("avd.ini.displayname", "Unknown");
        }

        private final DeviceFramingOption getFramingOption(Map<String, String> $this$getFramingOption) {
            String skinPathValue = $this$getFramingOption.get("skin.path");
            if (skinPathValue == null || Intrinsics.areEqual((Object)skinPathValue, (Object)"_no_skin")) {
                return null;
            }
            Path skinPath = Path.of(skinPathValue, new String[0]);
            String string = AndroidAdbUiBundle.message("screenshot.framing.option.name", new Object[0]);
            Intrinsics.checkNotNull((Object)skinPath);
            return new DeviceFramingOption(string, skinPath);
        }

        private final DeviceFramingOption framingOptionFromModel(String deviceModel) {
            Object v0;
            block3: {
                Iterable iterable = this.getDevices();
                for (Object t : iterable) {
                    Device it = (Device)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)deviceModel)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            Device device2 = v0;
            if (device2 == null) {
                return null;
            }
            Device device3 = device2;
            Path path = this.getSkinFolder(device3);
            if (path == null) {
                return null;
            }
            Path skinFolder = path;
            String string = device3.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            return new DeviceFramingOption(string, skinFolder);
        }

        private final Collection<Device> getDevices() {
            DeviceManager deviceManager = DeviceManagers.getDeviceManager(AndroidSdkHandler.Companion.getInstance((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE, null));
            Object[] objectArray = new DeviceManager.DeviceCategory[]{DeviceManager.DeviceCategory.USER, DeviceManager.DeviceCategory.DEFAULT, DeviceManager.DeviceCategory.VENDOR};
            Collection collection2 = deviceManager.getDevices((Collection)SetsKt.setOf((Object[])objectArray));
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getDevices(...)");
            return collection2;
        }

        private final Path getSkinFolder(Device $this$skinFolder) {
            Comparable<File> comparable = $this$skinFolder.getDefaultHardware().getSkinFile();
            if (comparable == null || (comparable = ((File)comparable).toPath()) == null) {
                return null;
            }
            Comparable<File> skinFolder = comparable;
            if (Intrinsics.areEqual((Object)skinFolder, (Object)SkinUtils.noSkin())) {
                return null;
            }
            if (!skinFolder.isAbsolute()) {
                Path path = skinHome;
                if (path == null || (path = path.resolve((Path)skinFolder)) == null) {
                    return null;
                }
                skinFolder = path;
            }
            if (!Files.exists(skinFolder.resolve("layout"), new LinkOption[0]) && !Files.exists(skinFolder.resolve("default/layout"), new LinkOption[0])) {
                return null;
            }
            return skinFolder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/ui/screenshot/ScreenshotParameters$MatchingSkin;", "", "displayName", "", "skinFolder", "Ljava/nio/file/Path;", "matchDistance", "", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;D)V", "getDisplayName", "()Ljava/lang/String;", "getSkinFolder", "()Ljava/nio/file/Path;", "getMatchDistance", "()D", "intellij.android.adb.ui"})
    private static final class MatchingSkin {
        @NotNull
        private final String displayName;
        @NotNull
        private final Path skinFolder;
        private final double matchDistance;

        public MatchingSkin(@NotNull String displayName, @NotNull Path skinFolder, double matchDistance) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)skinFolder, (String)"skinFolder");
            this.displayName = displayName;
            this.skinFolder = skinFolder;
            this.matchDistance = matchDistance;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final Path getSkinFolder() {
            return this.skinFolder;
        }

        public final double getMatchDistance() {
            return this.matchDistance;
        }
    }
}

