/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenrecording;

import com.android.tools.idea.ui.save.SaveConfiguration;
import com.android.tools.idea.ui.screenrecording.DeviceScreenRecordingSettingsKt;
import com.android.tools.idea.ui.screenrecording.ScreenRecorderOptions;
import com.android.tools.idea.ui.screenrecording.ScreenRecorderPersistentOptions;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@State(name="DeviceScreenRecordingSettings", storages={@Storage(value="other.xml")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 -2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\"\u001a\u00020\u0000H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0000H\u0016J \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00112\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0013\"\u0004\b!\u0010\u0015\u00a8\u0006."}, d2={"Lcom/android/tools/idea/ui/screenrecording/DeviceScreenRecordingSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "<init>", "()V", "saveConfig", "Lcom/android/tools/idea/ui/save/SaveConfiguration;", "getSaveConfig", "()Lcom/android/tools/idea/ui/save/SaveConfiguration;", "setSaveConfig", "(Lcom/android/tools/idea/ui/save/SaveConfiguration;)V", "scale", "", "getScale", "()D", "setScale", "(D)V", "bitRateMbps", "", "getBitRateMbps", "()I", "setBitRateMbps", "(I)V", "showTaps", "", "getShowTaps", "()Z", "setShowTaps", "(Z)V", "useEmulatorRecordingWhenAvailable", "getUseEmulatorRecordingWhenAvailable", "setUseEmulatorRecordingWhenAvailable", "recordingCount", "getRecordingCount", "setRecordingCount", "getState", "noStateLoaded", "", "loadState", "state", "toScreenRecorderOptions", "Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderOptions;", "displayId", "size", "Ljava/awt/Dimension;", "timeLimitSec", "Companion", "intellij.android.adb.ui"})
@SourceDebugExtension(value={"SMAP\nDeviceScreenRecordingSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceScreenRecordingSettings.kt\ncom/android/tools/idea/ui/screenrecording/DeviceScreenRecordingSettings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,113:1\n1#2:114\n40#3,3:115\n*S KotlinDebug\n*F\n+ 1 DeviceScreenRecordingSettings.kt\ncom/android/tools/idea/ui/screenrecording/DeviceScreenRecordingSettings\n*L\n51#1:115,3\n*E\n"})
public final class DeviceScreenRecordingSettings
implements PersistentStateComponent<DeviceScreenRecordingSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private SaveConfiguration saveConfig;
    private double scale;
    private int bitRateMbps;
    private boolean showTaps;
    private boolean useEmulatorRecordingWhenAvailable;
    private int recordingCount;

    /*
     * WARNING - void declaration
     */
    public DeviceScreenRecordingSettings() {
        void $this$saveConfig_u24lambda_u240;
        SaveConfiguration saveConfiguration;
        SaveConfiguration saveConfiguration2 = saveConfiguration = new SaveConfiguration();
        DeviceScreenRecordingSettings deviceScreenRecordingSettings = this;
        boolean bl = false;
        $this$saveConfig_u24lambda_u240.setFilenameTemplate("Screen_recording_<yyyy><MM><dd>_<HH><mm><ss>");
        deviceScreenRecordingSettings.saveConfig = saveConfiguration;
        this.scale = 1.0;
        this.bitRateMbps = 4;
        this.useEmulatorRecordingWhenAvailable = true;
    }

    @NotNull
    public final SaveConfiguration getSaveConfig() {
        return this.saveConfig;
    }

    public final void setSaveConfig(@NotNull SaveConfiguration saveConfiguration) {
        Intrinsics.checkNotNullParameter((Object)saveConfiguration, (String)"<set-?>");
        this.saveConfig = saveConfiguration;
    }

    public final double getScale() {
        return this.scale;
    }

    public final void setScale(double d) {
        this.scale = d;
    }

    public final int getBitRateMbps() {
        return this.bitRateMbps;
    }

    public final void setBitRateMbps(int n) {
        this.bitRateMbps = n;
    }

    public final boolean getShowTaps() {
        return this.showTaps;
    }

    public final void setShowTaps(boolean bl) {
        this.showTaps = bl;
    }

    public final boolean getUseEmulatorRecordingWhenAvailable() {
        return this.useEmulatorRecordingWhenAvailable;
    }

    public final void setUseEmulatorRecordingWhenAvailable(boolean bl) {
        this.useEmulatorRecordingWhenAvailable = bl;
    }

    public final int getRecordingCount() {
        return this.recordingCount;
    }

    public final void setRecordingCount(int n) {
        this.recordingCount = n;
    }

    @NotNull
    public DeviceScreenRecordingSettings getState() {
        return this;
    }

    public void noStateLoaded() {
        boolean $i$f$service = false;
        Class<ScreenRecorderPersistentOptions> serviceClass$iv = ScreenRecorderPersistentOptions.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ScreenRecorderPersistentOptions screenRecordingOptions = (ScreenRecorderPersistentOptions)object;
        this.saveConfig.setSaveLocation(screenRecordingOptions.getSaveLocation());
        this.saveConfig.setFilenameTemplate(screenRecordingOptions.getFilenameTemplate());
        this.saveConfig.setPostSaveAction(screenRecordingOptions.getPostSaveAction());
        this.scale = (double)screenRecordingOptions.getResolutionPercent() / 100.0;
        this.bitRateMbps = screenRecordingOptions.getBitRateMbps();
        this.showTaps = screenRecordingOptions.getShowTaps();
        this.useEmulatorRecordingWhenAvailable = screenRecordingOptions.getUseEmulatorRecording();
        this.recordingCount = screenRecordingOptions.getRecordingCount();
        screenRecordingOptions.loadState(new ScreenRecorderPersistentOptions());
    }

    public void loadState(@NotNull DeviceScreenRecordingSettings state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }

    @NotNull
    public final ScreenRecorderOptions toScreenRecorderOptions(int displayId, @Nullable Dimension size, int timeLimitSec) {
        int width = 0;
        int height = 0;
        if (size != null && !(this.scale == 1.0)) {
            width = DeviceScreenRecordingSettingsKt.access$roundToMultipleOf16((double)size.width * this.scale);
            height = DeviceScreenRecordingSettingsKt.access$roundToMultipleOf16((double)size.height * this.scale);
        } else {
            width = 0;
            height = 0;
        }
        return new ScreenRecorderOptions(displayId, width, height, this.bitRateMbps, this.showTaps, timeLimitSec);
    }

    @JvmStatic
    @NotNull
    public static final DeviceScreenRecordingSettings getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/ui/screenrecording/DeviceScreenRecordingSettings$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/ui/screenrecording/DeviceScreenRecordingSettings;", "intellij.android.adb.ui"})
    @SourceDebugExtension(value={"SMAP\nDeviceScreenRecordingSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceScreenRecordingSettings.kt\ncom/android/tools/idea/ui/screenrecording/DeviceScreenRecordingSettings$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,113:1\n40#2,3:114\n*S KotlinDebug\n*F\n+ 1 DeviceScreenRecordingSettings.kt\ncom/android/tools/idea/ui/screenrecording/DeviceScreenRecordingSettings$Companion\n*L\n85#1:114,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DeviceScreenRecordingSettings getInstance() {
            boolean $i$f$service = false;
            Class<DeviceScreenRecordingSettings> serviceClass$iv = DeviceScreenRecordingSettings.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (DeviceScreenRecordingSettings)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

