/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.AssetModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ShapeModel;
import com.google.common.collect.ImmutableList;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class DrawableAssetModel
implements AssetModel {
    private final Rectangle2D.Double myArtboardDimension;
    private final Rectangle2D.Double myViewportDimension;
    private ImmutableList<ShapeModel> myShapeModels;
    private boolean myExportable;
    private String myName;
    private AssetModel.Origin myOrigin;

    public DrawableAssetModel(@NotNull ImmutableList<ShapeModel> shapeModels, boolean exportable, @NotNull String name2, @NotNull Rectangle2D.Double artboardDimension, @NotNull Rectangle2D.Double viewportDimension, @NotNull AssetModel.Origin origin) {
        this.myShapeModels = shapeModels;
        this.myExportable = exportable;
        this.myName = name2.replaceAll("[ :\\\\/*\"?|<>%.']", "_").toLowerCase(Locale.ENGLISH);
        this.myArtboardDimension = artboardDimension;
        this.myViewportDimension = viewportDimension;
        this.myOrigin = origin;
    }

    @NotNull
    public ImmutableList<ShapeModel> getShapeModels() {
        return this.myShapeModels;
    }

    public double getArtboardWidth() {
        return this.myArtboardDimension.getWidth();
    }

    public double getArtboardHeight() {
        return this.myArtboardDimension.getHeight();
    }

    public double getViewportWidth() {
        return this.myViewportDimension.getWidth();
    }

    public double getViewportHeight() {
        return this.myViewportDimension.getHeight();
    }

    @Override
    public boolean isExportable() {
        return this.myExportable;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    public void setName(@NotNull String name2) {
        this.myName = name2;
    }

    @Override
    @NotNull
    public AssetModel.Origin getOrigin() {
        return this.myOrigin;
    }
}

