/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.rendering;

import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.ConfigurationForFile;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.ui.resourcemanager.model.Asset;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.android.tools.idea.ui.resourcemanager.model.DesignAssetKt;
import com.android.tools.idea.ui.resourcemanager.plugin.LayoutRenderOptions;
import com.android.tools.idea.ui.resourcemanager.plugin.LayoutRenderer;
import com.android.tools.idea.ui.resourcemanager.rendering.ResourceRenderingUtilsKt;
import com.android.tools.idea.ui.resourcemanager.rendering.SlowResourcePreviewProvider;
import com.android.tools.idea.util.FileExtensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.scale.JBUIScale;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\"\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/rendering/LayoutSlowPreviewProvider;", "Lcom/android/tools/idea/ui/resourcemanager/rendering/SlowResourcePreviewProvider;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "resourceResolver", "Lcom/android/ide/common/resources/ResourceResolver;", "renderingOptions", "Lcom/android/tools/idea/ui/resourcemanager/plugin/LayoutRenderOptions;", "placeholderImage", "Ljava/awt/image/BufferedImage;", "<init>", "(Lorg/jetbrains/android/facet/AndroidFacet;Lcom/android/ide/common/resources/ResourceResolver;Lcom/android/tools/idea/ui/resourcemanager/plugin/LayoutRenderOptions;Ljava/awt/image/BufferedImage;)V", "previewPlaceholder", "getPreviewPlaceholder", "()Ljava/awt/image/BufferedImage;", "getSlowPreview", "width", "", "height", "asset", "Lcom/android/tools/idea/ui/resourcemanager/model/Asset;", "getResolvedLayoutFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "designAsset", "Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "intellij.android.core"})
public final class LayoutSlowPreviewProvider
implements SlowResourcePreviewProvider {
    @NotNull
    private final AndroidFacet facet;
    @NotNull
    private final ResourceResolver resourceResolver;
    @Nullable
    private final LayoutRenderOptions renderingOptions;
    @NotNull
    private final BufferedImage previewPlaceholder;

    public LayoutSlowPreviewProvider(@NotNull AndroidFacet facet, @NotNull ResourceResolver resourceResolver, @Nullable LayoutRenderOptions renderingOptions, @Nullable BufferedImage placeholderImage) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)resourceResolver, (String)"resourceResolver");
        this.facet = facet;
        this.resourceResolver = resourceResolver;
        this.renderingOptions = renderingOptions;
        BufferedImage bufferedImage = placeholderImage;
        if (bufferedImage == null) {
            bufferedImage = ResourceRenderingUtilsKt.createLayoutPlaceholderImage(JBUIScale.scale((int)100), JBUIScale.scale((int)100));
        }
        this.previewPlaceholder = bufferedImage;
    }

    public /* synthetic */ LayoutSlowPreviewProvider(AndroidFacet androidFacet, ResourceResolver resourceResolver, LayoutRenderOptions layoutRenderOptions, BufferedImage bufferedImage, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            layoutRenderOptions = null;
        }
        if ((n & 8) != 0) {
            bufferedImage = null;
        }
        this(androidFacet, resourceResolver, layoutRenderOptions, bufferedImage);
    }

    @Override
    @NotNull
    public BufferedImage getPreviewPlaceholder() {
        return this.previewPlaceholder;
    }

    @Override
    @Nullable
    public BufferedImage getSlowPreview(int width, int height, @NotNull Asset asset) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        DesignAsset designAsset = asset instanceof DesignAsset ? (DesignAsset)asset : null;
        if (designAsset == null) {
            return null;
        }
        DesignAsset designAsset2 = designAsset;
        VirtualFile virtualFile = this.getResolvedLayoutFile(this.resourceResolver, designAsset2);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely((Project)this.facet.getModule().getProject(), (VirtualFile)file);
        XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (xmlFile == null) {
            return null;
        }
        XmlFile psiFile2 = xmlFile;
        ConfigurationForFile configurationForFile = ConfigurationManager.getOrCreateInstance(this.facet.getModule()).getConfiguration(file);
        Intrinsics.checkNotNullExpressionValue((Object)configurationForFile, (String)"getConfiguration(...)");
        ConfigurationForFile configuration2 = configurationForFile;
        return LayoutRenderer.Companion.getInstance(this.facet).getLayoutRender(psiFile2, configuration2, this.renderingOptions).get();
    }

    private final VirtualFile getResolvedLayoutFile(ResourceResolver $this$getResolvedLayoutFile, DesignAsset designAsset) {
        Object object;
        if (designAsset.getResourceItem().getType() == ResourceType.ATTR) {
            Object object2 = DesignAssetKt.resolveValue($this$getResolvedLayoutFile, designAsset);
            if (object2 != null && (object2 = object2.getValue()) != null) {
                Object it = object2;
                boolean bl = false;
                PathString pathString = ResourcesUtil.toFileResourcePathString((String)it);
                object = pathString != null ? FileExtensions.toVirtualFile$default(pathString, false, 1, null) : null;
            } else {
                object = null;
            }
        } else {
            object = designAsset.getFile();
        }
        return object;
    }
}

