/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.rendering;

import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.resources.ResourceItem;
import com.android.tools.fonts.ProjectFonts;
import com.android.tools.idea.fonts.StudioDownloadableFontCacheService;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.ui.resourcemanager.model.Asset;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetIconProvider;
import com.android.tools.idea.ui.resourcemanager.rendering.FontFamilyIcon;
import java.awt.Component;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JD\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/rendering/FontIconProvider;", "Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetIconProvider;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "<init>", "(Lorg/jetbrains/android/facet/AndroidFacet;)V", "fontIcon", "Lcom/android/tools/idea/ui/resourcemanager/rendering/FontFamilyIcon;", "projectFonts", "Lcom/android/tools/fonts/ProjectFonts;", "supportsTransparency", "", "getSupportsTransparency", "()Z", "getIcon", "Ljavax/swing/Icon;", "assetToRender", "Lcom/android/tools/idea/ui/resourcemanager/model/Asset;", "width", "", "height", "component", "Ljava/awt/Component;", "refreshCallback", "Lkotlin/Function0;", "", "shouldBeRendered", "intellij.android.core"})
public final class FontIconProvider
implements AssetIconProvider {
    @NotNull
    private final FontFamilyIcon fontIcon;
    @NotNull
    private final ProjectFonts projectFonts;
    private final boolean supportsTransparency;

    public FontIconProvider(@NotNull AndroidFacet facet) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        this.fontIcon = new FontFamilyIcon();
        this.projectFonts = new ProjectFonts(StudioDownloadableFontCacheService.Companion.getInstance(), StudioResourceRepositoryManager.getInstance(facet));
    }

    @Override
    public boolean getSupportsTransparency() {
        return this.supportsTransparency;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull Asset assetToRender, int width, int height, @NotNull Component component, @NotNull Function0<Unit> refreshCallback, @NotNull Function0<Boolean> shouldBeRendered) {
        Intrinsics.checkNotNullParameter((Object)assetToRender, (String)"assetToRender");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter(refreshCallback, (String)"refreshCallback");
        Intrinsics.checkNotNullParameter(shouldBeRendered, (String)"shouldBeRendered");
        ResourceItem resource = assetToRender.getResourceItem();
        FontFamily fontFamily = this.projectFonts.getFont(resource.getReferenceToSelf().getResourceUrl().toString());
        Intrinsics.checkNotNullExpressionValue((Object)fontFamily, (String)"getFont(...)");
        FontFamily fontFamily2 = fontFamily;
        this.fontIcon.setWidth(width);
        this.fontIcon.setHeight(height);
        this.fontIcon.setFontFamily(fontFamily2);
        return this.fontIcon;
    }
}

