/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.plugin;

import com.android.resources.ResourceType;
import com.android.tools.idea.ui.resourcemanager.importer.QualifierMatcher;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRendererManager;
import com.android.tools.idea.ui.resourcemanager.plugin.ResourceImporterKt;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dJ\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H&J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0014\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006\u001e\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/ResourceImporter;", "", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "getSupportedFileTypes", "", "supportsBatchImport", "", "getSupportsBatchImport", "()Z", "invokeCustomImporter", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "filePaths", "", "hasCustomImport", "getHasCustomImport", "userCanEditQualifiers", "getUserCanEditQualifiers", "getSourcePreview", "Lcom/android/tools/idea/ui/resourcemanager/plugin/DesignAssetRenderer;", "asset", "Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "processFile", "file", "Ljava/io/File;", "Companion", "intellij.android.core"})
public interface ResourceImporter {
    @NotNull
    public static final Companion Companion = com.android.tools.idea.ui.resourcemanager.plugin.ResourceImporter$Companion.$$INSTANCE;

    @NotNull
    public String getPresentableName();

    @NotNull
    public Set<String> getSupportedFileTypes();

    default public boolean getSupportsBatchImport() {
        return true;
    }

    default public void invokeCustomImporter(@NotNull AndroidFacet facet, @NotNull Collection<String> filePaths) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter(filePaths, (String)"filePaths");
    }

    default public boolean getHasCustomImport() {
        return false;
    }

    default public boolean getUserCanEditQualifiers() {
        return true;
    }

    @Nullable
    public DesignAssetRenderer getSourcePreview(@NotNull DesignAsset var1);

    @Nullable
    default public DesignAsset processFile(@NotNull File file) {
        DesignAsset designAsset;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        if (virtualFile == null) {
            ResourceImporterKt.access$getLOG().warn("Failed to find file in VFS: " + file.getPath() + ".");
            return null;
        }
        if (DesignAssetRendererManager.Companion.getInstance().hasViewer(virtualFile)) {
            QualifierMatcher qualifierMatcher = new QualifierMatcher(null, 1, null);
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            QualifierMatcher.Result qualifierMatcherResult = qualifierMatcher.parsePath(string);
            designAsset = new DesignAsset(virtualFile, CollectionsKt.toList((Iterable)qualifierMatcherResult.getQualifiers()), ResourceType.RAW, qualifierMatcherResult.getResourceName(), null, 16, null);
        } else {
            ResourceImporterKt.access$getLOG().warn("No viewer for: " + virtualFile.getName() + ".");
            designAsset = null;
        }
        return designAsset;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/ResourceImporter$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/android/tools/idea/ui/resourcemanager/plugin/ResourceImporter;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "intellij.android.core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final ExtensionPointName<ResourceImporter> EP_NAME;

        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<ResourceImporter> getEP_NAME() {
            return EP_NAME;
        }

        static {
            $$INSTANCE = new Companion();
            EP_NAME = ExtensionPointName.Companion.create("com.android.resourceImporter");
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        public static boolean getSupportsBatchImport(@NotNull ResourceImporter $this) {
            return $this.getSupportsBatchImport();
        }

        @Deprecated
        public static void invokeCustomImporter(@NotNull ResourceImporter $this, @NotNull AndroidFacet facet, @NotNull Collection<String> filePaths) {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            Intrinsics.checkNotNullParameter(filePaths, (String)"filePaths");
            $this.invokeCustomImporter(facet, filePaths);
        }

        @Deprecated
        public static boolean getHasCustomImport(@NotNull ResourceImporter $this) {
            return $this.getHasCustomImport();
        }

        @Deprecated
        public static boolean getUserCanEditQualifiers(@NotNull ResourceImporter $this) {
            return $this.getUserCanEditQualifiers();
        }

        @Deprecated
        @Nullable
        public static DesignAsset processFile(@NotNull ResourceImporter $this, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return $this.processFile(file);
        }
    }
}

