/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.plugin;

import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.tools.idea.ui.resourcemanager.importer.QualifierMatcher;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.android.tools.idea.ui.resourcemanager.model.Mapper;
import com.android.tools.idea.ui.resourcemanager.model.StaticStringMapper;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRendererManager;
import com.android.tools.idea.ui.resourcemanager.plugin.RasterAssetRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.ResourceImporter;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/RasterResourceImporter;", "Lcom/android/tools/idea/ui/resourcemanager/plugin/ResourceImporter;", "<init>", "()V", "iOsMapper", "Lcom/android/tools/idea/ui/resourcemanager/model/StaticStringMapper;", "androidMapper", "matcher", "Lcom/android/tools/idea/ui/resourcemanager/importer/QualifierMatcher;", "getMatcher", "()Lcom/android/tools/idea/ui/resourcemanager/importer/QualifierMatcher;", "processFile", "Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "file", "Ljava/io/File;", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "getSupportedFileTypes", "", "userCanEditQualifiers", "", "getUserCanEditQualifiers", "()Z", "getSourcePreview", "Lcom/android/tools/idea/ui/resourcemanager/plugin/DesignAssetRenderer;", "asset", "Companion", "intellij.android.core"})
public final class RasterResourceImporter
implements ResourceImporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StaticStringMapper iOsMapper;
    @NotNull
    private final StaticStringMapper androidMapper;
    @NotNull
    private final QualifierMatcher matcher;
    @NotNull
    private final String presentableName;
    @NotNull
    private static final Set<String> imageTypeExtensions;

    public RasterResourceImporter() {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"@4x", (Object)new DensityQualifier(Density.XXXHIGH)), TuplesKt.to((Object)"@3x", (Object)new DensityQualifier(Density.XXHIGH)), TuplesKt.to((Object)"@2x", (Object)new DensityQualifier(Density.XHIGH)), TuplesKt.to((Object)"@1x", (Object)new DensityQualifier(Density.MEDIUM))};
        this.iOsMapper = new StaticStringMapper(MapsKt.mapOf((Pair[])objectArray), null, 2, null);
        objectArray = new Pair[]{TuplesKt.to((Object)"xxxhdpi", (Object)new DensityQualifier(Density.XXXHIGH)), TuplesKt.to((Object)"xxhdpi", (Object)new DensityQualifier(Density.XXHIGH)), TuplesKt.to((Object)"xhdpi", (Object)new DensityQualifier(Density.XHIGH)), TuplesKt.to((Object)"hdpi", (Object)new DensityQualifier(Density.HIGH)), TuplesKt.to((Object)"mdpi", (Object)new DensityQualifier(Density.MEDIUM)), TuplesKt.to((Object)"ldpi", (Object)new DensityQualifier(Density.LOW))};
        this.androidMapper = new StaticStringMapper(MapsKt.mapOf((Pair[])objectArray), null, 2, null);
        objectArray = new Mapper[]{this.androidMapper, this.iOsMapper};
        this.matcher = new QualifierMatcher((Mapper<? extends ResourceQualifier>[])objectArray);
        this.presentableName = "Simple Image Importer";
    }

    @NotNull
    public final QualifierMatcher getMatcher() {
        return this.matcher;
    }

    @Override
    @Nullable
    public DesignAsset processFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        QualifierMatcher.Result qualifierMatcherResult = this.matcher.parsePath(string);
        return new DesignAsset(virtualFile2, CollectionsKt.toList((Iterable)qualifierMatcherResult.getQualifiers()), ResourceType.DRAWABLE, qualifierMatcherResult.getResourceName(), null, 16, null);
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.presentableName;
    }

    @Override
    @NotNull
    public Set<String> getSupportedFileTypes() {
        return imageTypeExtensions;
    }

    @Override
    public boolean getUserCanEditQualifiers() {
        return true;
    }

    @Override
    @Nullable
    public DesignAssetRenderer getSourcePreview(@NotNull DesignAsset asset) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        return DesignAssetRendererManager.Companion.getInstance().getViewer(RasterAssetRenderer.class);
    }

    @Override
    public boolean getSupportsBatchImport() {
        return ResourceImporter.super.getSupportsBatchImport();
    }

    @Override
    public void invokeCustomImporter(@NotNull AndroidFacet facet, @NotNull Collection<String> filePaths) {
        ResourceImporter.super.invokeCustomImporter(facet, filePaths);
    }

    @Override
    public boolean getHasCustomImport() {
        return ResourceImporter.super.getHasCustomImport();
    }

    static {
        String[] stringArray = ImageIO.getReaderFormatNames();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getReaderFormatNames(...)");
        imageTypeExtensions = ArraysKt.toSet((Object[])stringArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/RasterResourceImporter$Companion;", "", "<init>", "()V", "imageTypeExtensions", "", "", "kotlin.jvm.PlatformType", "getImageTypeExtensions", "()Ljava/util/Set;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getImageTypeExtensions() {
            return imageTypeExtensions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

