/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.plugin;

import com.android.tools.idea.rendering.DrawableRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.DrawableAssetRendererKt;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.text.ParseException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J6\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00120\b2\u0006\u0010\u0010\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001a\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00120\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/DrawableAssetRenderer;", "Lcom/android/tools/idea/ui/resourcemanager/plugin/DesignAssetRenderer;", "<init>", "()V", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "kotlin.jvm.PlatformType", "createRenderer", "Ljava/util/concurrent/CompletableFuture;", "Lcom/android/tools/idea/rendering/DrawableRenderer;", "module", "Lcom/intellij/openapi/module/Module;", "targetFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isFileSupported", "", "file", "getImage", "Ljava/awt/image/BufferedImage;", "dimension", "Ljava/awt/Dimension;", "context", "", "failedFuture", "exception", "", "intellij.android.core"})
public final class DrawableAssetRenderer
implements DesignAssetRenderer {
    private final DocumentBuilder documentBuilder = DocumentBuilderFactory.newDefaultInstance().newDocumentBuilder();

    private final CompletableFuture<DrawableRenderer> createRenderer(Module module, VirtualFile targetFile) {
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet == null) {
            CompletableFuture<DrawableRenderer> completableFuture;
            CompletableFuture<DrawableRenderer> it = completableFuture = new CompletableFuture<DrawableRenderer>();
            boolean bl = false;
            it.completeExceptionally(new NullPointerException("Facet for module " + module + " couldn't be found for use in DrawableRenderer."));
            return completableFuture;
        }
        AndroidFacet facet = androidFacet;
        CompletableFuture<DrawableRenderer> completableFuture = CompletableFuture.supplyAsync(() -> DrawableAssetRenderer.createRenderer$lambda$1(facet, targetFile), AppExecutorUtil.getAppExecutorService());
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    @Override
    public boolean isFileSupported(@NotNull VirtualFile file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)XmlFileType.INSTANCE) || file.getLength() == 0L) {
            return false;
        }
        try {
            Document document = this.documentBuilder.parse(file.getInputStream());
            bl = ArraysKt.contains((Object[])DrawableAssetRendererKt.access$getSUPPORTED_DRAWABLE_TAG$p(), (Object)document.getDocumentElement().getNodeName());
        }
        catch (SAXParseException ex) {
            DrawableAssetRendererKt.access$getLOG$p().debug(Reflection.getOrCreateKotlinClass(ex.getClass()).getSimpleName() + " in " + file.getPath(), (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            DrawableAssetRendererKt.access$getLOG$p().warn(Reflection.getOrCreateKotlinClass(ex.getClass()).getSimpleName() + " in " + file.getPath(), (Throwable)ex);
            return false;
        }
        return bl;
    }

    @Override
    @NotNull
    public CompletableFuture<? extends BufferedImage> getImage(@NotNull VirtualFile file, @Nullable Module module, @NotNull Dimension dimension2, @Nullable Object context) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)dimension2, (String)"dimension");
        try {
            if (module == null) {
                CompletableFuture completableFuture;
                CompletableFuture it = completableFuture = new CompletableFuture();
                boolean bl = false;
                it.completeExceptionally(new NullPointerException("Module cannot be null to render a Drawable."));
                return completableFuture;
            }
            if (!this.isFileSupported(file)) {
                CompletableFuture completableFuture;
                CompletableFuture it = completableFuture = new CompletableFuture();
                boolean bl = false;
                it.completeExceptionally(new ParseException(file.getPath() + " couldn't be parsed as a drawable.", 0));
                return completableFuture;
            }
            VirtualFile contextFile = context instanceof VirtualFile ? (VirtualFile)context : null;
            VirtualFile virtualFile = contextFile;
            if (virtualFile == null) {
                virtualFile = file;
            }
            VirtualFile targetFile = virtualFile;
            CompletableFuture<DrawableRenderer> renderer2 = this.createRenderer(module, targetFile);
            byte[] byArray = file.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
            byte[] byArray2 = byArray;
            String xmlContent = new String(byArray2, Charsets.UTF_8);
            CompletionStage completionStage = ((CompletableFuture)renderer2.thenCompose(arg_0 -> DrawableAssetRenderer.getImage$lambda$5(arg_0 -> DrawableAssetRenderer.getImage$lambda$4(xmlContent, dimension2, arg_0), arg_0))).whenComplete((arg_0, arg_1) -> DrawableAssetRenderer.getImage$lambda$7((arg_0, arg_1) -> DrawableAssetRenderer.getImage$lambda$6(renderer2, arg_0, arg_1), arg_0, arg_1));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"whenComplete(...)");
            return completionStage;
        }
        catch (Exception ex) {
            return this.failedFuture(ex);
        }
    }

    private final CompletableFuture<? extends BufferedImage> failedFuture(Throwable exception) {
        DrawableAssetRendererKt.access$getLOG$p().warn(exception);
        CompletableFuture failedFuture = new CompletableFuture();
        failedFuture.completeExceptionally(exception);
        return failedFuture;
    }

    private static final DrawableRenderer createRenderer$lambda$1(AndroidFacet $facet, VirtualFile $targetFile) {
        return new DrawableRenderer($facet, $targetFile);
    }

    private static final CompletionStage getImage$lambda$4(String $xmlContent, Dimension $dimension, DrawableRenderer drawableRenderer) {
        return drawableRenderer.renderDrawable($xmlContent, $dimension);
    }

    private static final CompletionStage getImage$lambda$5(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final Unit getImage$lambda$6(CompletableFuture $renderer, BufferedImage bufferedImage, Throwable throwable) {
        Disposer.dispose((Disposable)((Disposable)$renderer.get()));
        return Unit.INSTANCE;
    }

    private static final void getImage$lambda$7(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

