/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.model;

import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.ui.resourcemanager.model.Asset;
import com.android.tools.idea.ui.resourcemanager.model.AssetKey;
import com.android.tools.idea.ui.resourcemanager.model.DesignAssetKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u001b\u001a\u00020\nJ\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\bH\u00c6\u0003J\t\u0010'\u001a\u00020\nH\u00c6\u0003J\t\u0010(\u001a\u00020\fH\u00c6\u0003JA\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\t\u00100\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00061"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "Lcom/android/tools/idea/ui/resourcemanager/model/Asset;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "qualifiers", "", "Lcom/android/ide/common/resources/configuration/ResourceQualifier;", "type", "Lcom/android/resources/ResourceType;", "name", "", "resourceItem", "Lcom/android/ide/common/resources/ResourceItem;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;Lcom/android/resources/ResourceType;Ljava/lang/String;Lcom/android/ide/common/resources/ResourceItem;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getQualifiers", "()Ljava/util/List;", "setQualifiers", "(Ljava/util/List;)V", "getType", "()Lcom/android/resources/ResourceType;", "getName", "()Ljava/lang/String;", "getResourceItem", "()Lcom/android/ide/common/resources/ResourceItem;", "getDisplayableFileSize", "key", "Lcom/android/tools/idea/ui/resourcemanager/model/AssetKey;", "getKey", "()Lcom/android/tools/idea/ui/resourcemanager/model/AssetKey;", "modificationStamp", "", "getModificationStamp", "()J", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.android.core"})
public final class DesignAsset
implements Asset {
    @NotNull
    private final VirtualFile file;
    @NotNull
    private List<? extends ResourceQualifier> qualifiers;
    @NotNull
    private final ResourceType type;
    @NotNull
    private final String name;
    @NotNull
    private final ResourceItem resourceItem;

    public DesignAsset(@NotNull VirtualFile file, @NotNull List<? extends ResourceQualifier> qualifiers, @NotNull ResourceType type, @NotNull String name2, @NotNull ResourceItem resourceItem) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(qualifiers, (String)"qualifiers");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)resourceItem, (String)"resourceItem");
        this.file = file;
        this.qualifiers = qualifiers;
        this.type = type;
        this.name = name2;
        this.resourceItem = resourceItem;
    }

    public /* synthetic */ DesignAsset(VirtualFile virtualFile, List list, ResourceType resourceType, String string, ResourceItem resourceItem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            String string2 = virtualFile.getNameWithoutExtension();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNameWithoutExtension(...)");
            string = string2;
        }
        if ((n & 0x10) != 0) {
            resourceItem = (ResourceItem)new ResourceMergerItem(string, DesignAssetKt.getExternalResourceNamespace(), resourceType, null, null, "external");
        }
        this(virtualFile, list, resourceType, string, resourceItem);
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final List<ResourceQualifier> getQualifiers() {
        return this.qualifiers;
    }

    public final void setQualifiers(@NotNull List<? extends ResourceQualifier> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.qualifiers = list;
    }

    @Override
    @NotNull
    public ResourceType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ResourceItem getResourceItem() {
        return this.resourceItem;
    }

    @NotNull
    public final String getDisplayableFileSize() {
        if (this.getResourceItem().isFileBased()) {
            String string = StringUtil.formatFileSize((long)this.file.getLength());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(...)");
            return string;
        }
        return "";
    }

    @Override
    @NotNull
    public AssetKey getKey() {
        return new AssetKey(this.getName(), this.getType(), this.file.getPath());
    }

    @Override
    public long getModificationStamp() {
        return this.file.getModificationStamp();
    }

    @NotNull
    public final VirtualFile component1() {
        return this.file;
    }

    @NotNull
    public final List<ResourceQualifier> component2() {
        return this.qualifiers;
    }

    @NotNull
    public final ResourceType component3() {
        return this.type;
    }

    @NotNull
    public final String component4() {
        return this.name;
    }

    @NotNull
    public final ResourceItem component5() {
        return this.resourceItem;
    }

    @NotNull
    public final DesignAsset copy(@NotNull VirtualFile file, @NotNull List<? extends ResourceQualifier> qualifiers, @NotNull ResourceType type, @NotNull String name2, @NotNull ResourceItem resourceItem) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(qualifiers, (String)"qualifiers");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)resourceItem, (String)"resourceItem");
        return new DesignAsset(file, qualifiers, type, name2, resourceItem);
    }

    public static /* synthetic */ DesignAsset copy$default(DesignAsset designAsset, VirtualFile virtualFile, List list, ResourceType resourceType, String string, ResourceItem resourceItem, int n, Object object) {
        if ((n & 1) != 0) {
            virtualFile = designAsset.file;
        }
        if ((n & 2) != 0) {
            list = designAsset.qualifiers;
        }
        if ((n & 4) != 0) {
            resourceType = designAsset.type;
        }
        if ((n & 8) != 0) {
            string = designAsset.name;
        }
        if ((n & 0x10) != 0) {
            resourceItem = designAsset.resourceItem;
        }
        return designAsset.copy(virtualFile, list, resourceType, string, resourceItem);
    }

    @NotNull
    public String toString() {
        return "DesignAsset(file=" + this.file + ", qualifiers=" + this.qualifiers + ", type=" + this.type + ", name=" + this.name + ", resourceItem=" + this.resourceItem + ")";
    }

    public int hashCode() {
        int result2 = this.file.hashCode();
        result2 = result2 * 31 + ((Object)this.qualifiers).hashCode();
        result2 = result2 * 31 + this.type.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + this.resourceItem.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DesignAsset)) {
            return false;
        }
        DesignAsset designAsset = (DesignAsset)other;
        if (!Intrinsics.areEqual((Object)this.file, (Object)designAsset.file)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.qualifiers, designAsset.qualifiers)) {
            return false;
        }
        if (this.type != designAsset.type) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)designAsset.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.resourceItem, (Object)designAsset.resourceItem);
    }

    @Override
    @NotNull
    public ResourceUrl getResourceUrl() {
        return Asset.super.getResourceUrl();
    }
}

