/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.explorer;

import com.android.tools.idea.ui.resourcemanager.explorer.ResourceExplorerToolbarViewModel;
import com.android.tools.idea.ui.resourcemanager.rendering.SlowResource;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/explorer/RefreshAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "viewModel", "Lcom/android/tools/idea/ui/resourcemanager/explorer/ResourceExplorerToolbarViewModel;", "<init>", "(Lcom/android/tools/idea/ui/resourcemanager/explorer/ResourceExplorerToolbarViewModel;)V", "getViewModel", "()Lcom/android/tools/idea/ui/resourcemanager/explorer/ResourceExplorerToolbarViewModel;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.android.core"})
final class RefreshAction
extends AnAction {
    @NotNull
    private final ResourceExplorerToolbarViewModel viewModel;

    public RefreshAction(@NotNull ResourceExplorerToolbarViewModel viewModel2) {
        Intrinsics.checkNotNullParameter((Object)viewModel2, (String)"viewModel");
        super("Refresh Previews", "Refresh previews for " + viewModel2.getResourceType().getDisplayName() + "s", AllIcons.Actions.Refresh);
        this.viewModel = viewModel2;
    }

    @NotNull
    public final ResourceExplorerToolbarViewModel getViewModel() {
        return this.viewModel;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.viewModel.getRefreshResourcesPreviewsCallback().invoke();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        if (SlowResource.Companion.isSlowResource(this.viewModel.getResourceType())) {
            e.getPresentation().setText(this.getTemplatePresentation().getText());
            e.getPresentation().setDescription(this.getTemplatePresentation().getDescription());
            e.getPresentation().setEnabled(true);
        } else {
            String text2 = this.viewModel.getResourceType().getDisplayName() + "s refresh automatically";
            e.getPresentation().setText(text2);
            e.getPresentation().setDescription(text2);
            e.getPresentation().setEnabled(false);
        }
    }
}

