/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.actions;

import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/actions/NewResourceValueAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "type", "Lcom/android/resources/ResourceType;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "createdResourceCallback", "Lkotlin/Function2;", "", "", "<init>", "(Lcom/android/resources/ResourceType;Lorg/jetbrains/android/facet/AndroidFacet;Lkotlin/jvm/functions/Function2;)V", "actionPerformed", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.android.core"})
public final class NewResourceValueAction
extends AnAction {
    @NotNull
    private final ResourceType type;
    @NotNull
    private final AndroidFacet facet;
    @NotNull
    private final Function2<String, ResourceType, Unit> createdResourceCallback;

    public NewResourceValueAction(@NotNull ResourceType type, @NotNull AndroidFacet facet, @NotNull Function2<? super String, ? super ResourceType, Unit> createdResourceCallback) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter(createdResourceCallback, (String)"createdResourceCallback");
        super(type.getDisplayName() + " Value", "Create a new " + type.getDisplayName() + " resource value", null);
        this.type = type;
        this.facet = facet;
        this.createdResourceCallback = createdResourceCallback;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        CreateXmlResourceDialog dialog2 = new CreateXmlResourceDialog(this.facet.getModule(), this.type, null, null, true, null, null);
        dialog2.setTitle("New " + this.type.getDisplayName() + " Value");
        if (!dialog2.showAndGet()) {
            return;
        }
        Module module = this.facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
        Module module2 = module;
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile resDir = dialog2.getResourceDirectory();
        if (resDir == null) {
            Object[] objectArray = new Object[]{module2};
            AndroidUtils.reportError(project2, AndroidBundle.message("check.resource.dir.error", objectArray));
            return;
        }
        String fileName = dialog2.getFileName();
        List<String> dirNames = dialog2.getDirNames();
        String resValue = dialog2.getValue();
        String resName = dialog2.getResourceName();
        Intrinsics.checkNotNull((Object)resName);
        Intrinsics.checkNotNull((Object)fileName);
        Intrinsics.checkNotNull(dirNames);
        Intrinsics.checkNotNull((Object)resValue);
        if (!IdeResourcesUtil.createValueResource$default(project2, resDir, resName, this.type, fileName, dirNames, resValue, null, 128, null)) {
            return;
        }
        Project project3 = this.facet.getModule().getProject();
        ProgressManager.getInstance().run((Task)new Task.Modal(module2, project3){
            final /* synthetic */ Module $module;
            {
                this.$module = $module;
                super($super_call_param$1, "Refreshing Modified Files", false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                PsiDocumentManager.getInstance((Project)this.$module.getProject()).commitAllDocumentsUnderProgress();
            }
        });
        this.createdResourceCallback.invoke((Object)resName, (Object)this.type);
    }
}

