/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.tools.idea.io.grpc.BindableService;
import com.android.tools.idea.io.grpc.Server;
import com.android.tools.idea.io.grpc.ServerBuilder;
import com.android.tools.idea.io.grpc.inprocess.InProcessServerBuilder;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.intellij.openapi.Disposable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventStreamServer
implements Disposable {
    @NotNull
    private final String myServerName;
    @NotNull
    private final BlockingDeque<Common.Event> myEventQueue = new LinkedBlockingDeque<Common.Event>();
    @NotNull
    private final Map<String, String> myFilePathCache = new HashMap<String, String>();
    @NotNull
    private final Object myServerLock = new Object();
    private Server myServer;
    private StreamTransportService myTransportService;

    public EventStreamServer(@NotNull String serverName) {
        this.myServerName = serverName;
    }

    @NotNull
    public String getServerName() {
        return this.myServerName;
    }

    @NotNull
    public BlockingDeque<Common.Event> getEventDeque() {
        return this.myEventQueue;
    }

    @NotNull
    public Map<String, String> getFilePathCache() {
        return this.myFilePathCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        Object object = this.myServerLock;
        synchronized (object) {
            if (this.myServer != null) {
                throw new IllegalStateException(String.format("Server %s has already started", this.myServerName));
            }
            ServerBuilder builder = InProcessServerBuilder.forName((String)this.myServerName).directExecutor();
            this.myTransportService = new StreamTransportService();
            builder.addService((BindableService)this.myTransportService);
            this.myServer = builder.build();
            this.myServer.start();
        }
    }

    public void stop() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myServerLock;
        synchronized (object) {
            if (this.myServer == null || this.myServer.isShutdown()) {
                return;
            }
            this.myTransportService.shutDownAndWait();
            this.myServer.shutdownNow();
        }
    }

    private class StreamTransportService
    extends TransportServiceGrpc.TransportServiceImplBase {
        private Thread myEventStreamingThread;
        @Nullable
        private CountDownLatch myEventStreamingLatch;

        private StreamTransportService() {
        }

        private void shutDownAndWait() {
            if (this.myEventStreamingThread != null && this.myEventStreamingLatch != null) {
                try {
                    this.myEventStreamingThread.interrupt();
                    this.myEventStreamingLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void getEvents(Transport.GetEventsRequest request, StreamObserver<Common.Event> responseObserver2) {
            this.myEventStreamingLatch = new CountDownLatch(1);
            this.myEventStreamingThread = new Thread(() -> {
                while (!Thread.currentThread().isInterrupted() || !EventStreamServer.this.myEventQueue.isEmpty()) {
                    try {
                        Common.Event event = EventStreamServer.this.myEventQueue.take();
                        responseObserver2.onNext((Object)event);
                    }
                    catch (InterruptedException exception) {
                        Thread.currentThread().interrupt();
                    }
                }
                responseObserver2.onCompleted();
                this.myEventStreamingLatch.countDown();
            });
            this.myEventStreamingThread.start();
        }

        public void getFile(Transport.BytesRequest request, StreamObserver<Transport.FileResponse> responseObserver2) {
            String path = EventStreamServer.this.myFilePathCache.remove(request.getId());
            if (path != null) {
                responseObserver2.onNext((Object)Transport.FileResponse.newBuilder().setFilePath(path).build());
            } else {
                responseObserver2.onNext((Object)Transport.FileResponse.getDefaultInstance());
            }
            responseObserver2.onCompleted();
        }
    }
}

