/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.testsuite.temp;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.AndroidTestSuiteView;
import com.android.tools.idea.testartifacts.testsuite.GradleRunConfigurationExtension;
import com.android.tools.idea.testartifacts.testsuite.temp.GradleAndroidTestsExecutionConsoleOutputProcessor;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildViewManager;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.StartEvent;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationViewManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.time.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.filters.ReRunTaskFilter;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class GradleAndroidTestsExecutionConsoleManager
implements ExternalSystemExecutionConsoleManager<AndroidTestSuiteView, ProcessHandler> {
    @NotNull
    public ProjectSystemId getExternalSystemId() {
        return GradleConstants.SYSTEM_ID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public AndroidTestSuiteView attachExecutionConsole(@NotNull Project project, final @NotNull ExternalSystemTask task2, @Nullable ExecutionEnvironment env, @Nullable ProcessHandler processHandler) {
        RunConfiguration configuration2;
        if (env == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = env.getRunnerAndConfigurationSettings();
        if (settings == null) {
            RunProfile runProfile = env.getRunProfile();
            if (!(runProfile instanceof AbstractImportTestsAction.ImportRunProfile)) return null;
            configuration2 = ((AbstractImportTestsAction.ImportRunProfile)runProfile).getInitialConfiguration();
        } else {
            configuration2 = settings.getConfiguration();
        }
        if (!(configuration2 instanceof ExternalSystemRunConfiguration)) {
            return null;
        }
        AndroidTestSuiteView consoleView = new AndroidTestSuiteView((Disposable)project, project, null, null, configuration2, Clock.systemDefaultZone(), false, false);
        if (task2 instanceof ExternalSystemExecuteTaskTask) {
            consoleView.addMessageFilter((Filter)new ReRunTaskFilter((ExternalSystemExecuteTaskTask)task2, env));
        }
        final Disposable disposable = Disposer.newDisposable((Disposable)consoleView, (String)"Gradle test runner build event listener disposable");
        final BuildViewManager buildViewManager = (BuildViewManager)project.getService(BuildViewManager.class);
        ((ExternalSystemRunConfigurationViewManager)project.getService(ExternalSystemRunConfigurationViewManager.class)).addListener(new BuildProgressListener(){

            public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
                if (buildId != task2.getId()) {
                    return;
                }
                if (event instanceof FinishBuildEvent) {
                    Disposer.dispose((Disposable)disposable);
                } else if (event instanceof StartBuildEvent) {
                    BuildDescriptor buildDescriptor = ((StartBuildEvent)event).getBuildDescriptor();
                    DefaultBuildDescriptor defaultBuildDescriptor = new DefaultBuildDescriptor(buildDescriptor.getId(), buildDescriptor.getTitle(), buildDescriptor.getWorkingDir(), buildDescriptor.getStartTime());
                    defaultBuildDescriptor.setActivateToolWindowWhenFailed(false);
                    event = new StartBuildEventImpl((BuildDescriptor)defaultBuildDescriptor, event.getMessage());
                }
                buildViewManager.onEvent(buildId, event);
                if (event instanceof StartEvent) {
                    ProgressBuildEventImpl progressBuildEvent = new ProgressBuildEventImpl(event.getId(), event.getParentId(), event.getEventTime(), event.getMessage(), -1L, -1L, "");
                    progressBuildEvent.setHint("- " + GradleBundle.message((String)"gradle.test.runner.build.tw.link.title", (Object[])new Object[0]));
                    buildViewManager.onEvent(buildId, (BuildEvent)progressBuildEvent);
                }
            }
        }, disposable);
        return consoleView;
    }

    public void onOutput(@NotNull AndroidTestSuiteView executionConsole, @NotNull ProcessHandler processHandler, @NotNull String text2, @NotNull Key processOutputType) {
        GradleAndroidTestsExecutionConsoleOutputProcessor.onOutput(executionConsole, text2, processOutputType);
    }

    public boolean isApplicableFor(@NotNull ExternalSystemTask task2) {
        ExternalSystemExecuteTaskTask taskTask;
        if (!((Boolean)StudioFlags.ENABLE_ADDITIONAL_TESTING_GRADLE_OPTIONS.get()).booleanValue() && !((Boolean)StudioFlags.AGP_TEST_SUITES_ENABLED.get()).booleanValue()) {
            return false;
        }
        if (task2 instanceof ExternalSystemExecuteTaskTask && StringUtil.equals((CharSequence)(taskTask = (ExternalSystemExecuteTaskTask)task2).getExternalSystemId().getId(), (CharSequence)GradleConstants.SYSTEM_ID.getId())) {
            Boolean showResultInAndroidTestSuiteView = (Boolean)taskTask.getUserData(GradleRunConfigurationExtension.BooleanOptions.SHOW_TEST_RESULT_IN_ANDROID_TEST_SUITE_VIEW.getUserDataKey());
            return (Boolean)ObjectUtils.chooseNotNull((Object)showResultInAndroidTestSuiteView, (Object)false);
        }
        return false;
    }

    public AnAction[] getRestartActions(@NotNull AndroidTestSuiteView consoleView) {
        return AnAction.EMPTY_ARRAY;
    }
}

