/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.view;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultStats;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResults;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultsKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCaseResult;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestStep;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.benchmark.BenchmarkOutput;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.FilterableTreeNode;
import java.io.File;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010!\u001a\u00020\u0014H\u0016J\u0016\u0010!\u001a\u00020\u00142\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#H\u0016J\u0016\u0010$\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#H\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010%\u001a\u00020&2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#H\u0016J\u0016\u0010'\u001a\u00020(2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/TestStepRow;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResults;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/FilterableTreeNode;", "testStep", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestStep;", "<init>", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestStep;)V", "getTestStep", "()Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestStep;", "myTestSteps", "", "", "methodName", "getMethodName", "()Ljava/lang/String;", "className", "getClassName", "packageName", "getPackageName", "getTestCaseResult", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCaseResult;", "device", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "getLogcat", "getStartTime", "", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;)Ljava/lang/Long;", "getDuration", "Ljava/time/Duration;", "getTotalDuration", "getErrorStackTrace", "getAdditionalTestArtifacts", "", "getTestResultSummary", "devices", "", "getTestResultSummaryText", "getResultStats", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultStats;", "addTestStep", "", "intellij.android.testartifacts"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTestStepRow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestStepRow.kt\ncom/android/tools/idea/testartifacts/instrumented/testsuite/view/TestStepRow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1803#2,3:124\n1803#2,3:127\n*S KotlinDebug\n*F\n+ 1 TestStepRow.kt\ncom/android/tools/idea/testartifacts/instrumented/testsuite/view/TestStepRow\n*L\n102#1:124,3\n113#1:127,3\n*E\n"})
public final class TestStepRow
extends FilterableTreeNode
implements AndroidTestResults {
    @NotNull
    private final AndroidTestStep testStep;
    @NotNull
    private final Map<String, AndroidTestStep> myTestSteps;
    @NotNull
    private final String className;
    @NotNull
    private final String packageName;
    public static final int $stable = 8;

    public TestStepRow(@NotNull AndroidTestStep testStep) {
        Intrinsics.checkNotNullParameter((Object)testStep, (String)"testStep");
        this.testStep = testStep;
        this.myTestSteps = new LinkedHashMap();
        this.className = "";
        this.packageName = "";
    }

    @NotNull
    public final AndroidTestStep getTestStep() {
        return this.testStep;
    }

    @Override
    @NotNull
    public String getMethodName() {
        return this.testStep.getName();
    }

    @Override
    @NotNull
    public String getClassName() {
        return this.className;
    }

    @Override
    @NotNull
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    @Nullable
    public AndroidTestCaseResult getTestCaseResult(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        AndroidTestStep androidTestStep = this.myTestSteps.get(device2.getId());
        return androidTestStep != null ? androidTestStep.getResult() : null;
    }

    @Override
    @NotNull
    public String getLogcat(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Object object = this.myTestSteps.get(device2.getId());
        if (object == null || (object = ((AndroidTestStep)object).getLogcat()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    @Nullable
    public Long getStartTime(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        AndroidTestStep androidTestStep = this.myTestSteps.get(device2.getId());
        return androidTestStep != null ? androidTestStep.getStartTimestampMillis() : null;
    }

    @Override
    @Nullable
    public Duration getDuration(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Object object = this.myTestSteps.get(device2.getId());
        if (object == null || (object = ((AndroidTestStep)object).getStartTimestampMillis()) == null) {
            return null;
        }
        long start2 = (Long)object;
        Object object2 = this.myTestSteps.get(device2.getId());
        long end = object2 != null && (object2 = ((AndroidTestStep)object2).getEndTimestampMillis()) != null ? (Long)object2 : System.currentTimeMillis();
        return Duration.ofMillis(Math.max(end - start2, 0L));
    }

    @Override
    @NotNull
    public Duration getTotalDuration() {
        Duration duration = Duration.ofMillis(SequencesKt.sumOfLong((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.myTestSteps.values()), TestStepRow::getTotalDuration$lambda$0)));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        return duration;
    }

    @Override
    @NotNull
    public String getErrorStackTrace(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Object object = this.myTestSteps.get(device2.getId());
        if (object == null || (object = ((AndroidTestStep)object).getErrorStackTrace()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    @NotNull
    public Map<String, String> getAdditionalTestArtifacts(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Object object = this.myTestSteps.get(device2.getId());
        if (object == null || (object = ((AndroidTestStep)object).getAdditionalTestArtifacts()) == null) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    @Override
    @NotNull
    public AndroidTestCaseResult getTestResultSummary() {
        return AndroidTestResultsKt.getSummaryResult(this.getResultStats());
    }

    @Override
    @NotNull
    public AndroidTestCaseResult getTestResultSummary(@NotNull List<AndroidDevice> devices2) {
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        return AndroidTestResultsKt.getSummaryResult(this.getResultStats(devices2));
    }

    @Override
    @NotNull
    public String getTestResultSummaryText(@NotNull List<AndroidDevice> devices2) {
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        AndroidTestResultStats stats = this.getResultStats(devices2);
        return stats.getFailed() == 1 ? "Fail" : (stats.getFailed() > 0 ? "Fail (" + stats.getFailed() + ")" : (stats.getCancelled() > 0 ? "Cancelled" : (stats.getRunning() > 0 ? "Running" : (stats.getPassed() > 0 ? "Pass" : (stats.getSkipped() > 0 ? "Skip" : "")))));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AndroidTestResultStats getResultStats() {
        void $this$fold$iv;
        Iterable iterable = this.myTestSteps.values();
        AndroidTestResultStats initial$iv = new AndroidTestResultStats(0, 0, 0, 0, 0, 31, null);
        boolean $i$f$fold = false;
        AndroidTestResultStats accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void androidTestCase;
            AndroidTestStep androidTestStep = (AndroidTestStep)element$iv;
            AndroidTestResultStats acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.addTestCaseResult(androidTestCase.getResult());
        }
        return accumulator$iv;
    }

    @Override
    @NotNull
    public AndroidTestResultStats getResultStats(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        AndroidTestResultStats stats = new AndroidTestResultStats(0, 0, 0, 0, 0, 31, null);
        return stats.addTestCaseResult(this.getTestCaseResult(device2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AndroidTestResultStats getResultStats(@NotNull List<AndroidDevice> devices2) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        Iterable iterable = devices2;
        AndroidTestResultStats initial$iv = new AndroidTestResultStats(0, 0, 0, 0, 0, 31, null);
        boolean $i$f$fold = false;
        AndroidTestResultStats accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void device2;
            AndroidDevice androidDevice = (AndroidDevice)element$iv;
            AndroidTestResultStats acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.addTestCaseResult(this.getTestCaseResult((AndroidDevice)device2));
        }
        return accumulator$iv;
    }

    public final void addTestStep(@NotNull AndroidTestStep testStep, @NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)testStep, (String)"testStep");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.myTestSteps.put(device2.getId(), testStep);
    }

    @Override
    @NotNull
    public BenchmarkOutput getBenchmark(@NotNull AndroidDevice device2) {
        return AndroidTestResults.super.getBenchmark(device2);
    }

    @Override
    @Nullable
    public File getRetentionInfo(@NotNull AndroidDevice device2) {
        return AndroidTestResults.super.getRetentionInfo(device2);
    }

    @Override
    @Nullable
    public File getRetentionSnapshot(@NotNull AndroidDevice device2) {
        return AndroidTestResults.super.getRetentionSnapshot(device2);
    }

    private static final long getTotalDuration$lambda$0(AndroidTestStep it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Long l = it.getStartTimestampMillis();
        if (l == null) {
            return 0L;
        }
        long start2 = l;
        Long l2 = it.getEndTimestampMillis();
        long end = l2 != null ? l2 : System.currentTimeMillis();
        return Math.max(end - start2, 0L);
    }
}

