/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.model.benchmark;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.perfetto.PerfettoTraceWebLoader;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.benchmark.BenchmarkLinkListenerKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.benchmark.HyperlinkListener;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012:\b\u0002\u0010\u0006\u001a4\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0015\u0012\u0013\u0018\u00010\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\f\u0010\u0016\u001a\u00020\b*\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R@\u0010\u0006\u001a4\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0015\u0012\u0013\u0018\u00010\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/benchmark/BenchmarkLinkListener;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/benchmark/HyperlinkListener;", "project", "Lcom/intellij/openapi/project/Project;", "isPerfettoWebLoaderEnabled", "", "openTraceInPerfettoWebLoader", "Lkotlin/Function2;", "Ljava/io/File;", "Lkotlin/ParameterName;", "name", "file", "", "queryParams", "", "<init>", "(Lcom/intellij/openapi/project/Project;ZLkotlin/jvm/functions/Function2;)V", "hyperlinkClicked", "link", "isUiPerfettoDevSupportedFile", "fileName", "convertLinkToV3Format", "toIoFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.android.testartifacts"})
@StabilityInferred(parameters=0)
public final class BenchmarkLinkListener
implements HyperlinkListener {
    @NotNull
    private final Project project;
    private final boolean isPerfettoWebLoaderEnabled;
    @NotNull
    private final Function2<File, String, Unit> openTraceInPerfettoWebLoader;
    public static final int $stable = 8;

    public BenchmarkLinkListener(@NotNull Project project, boolean isPerfettoWebLoaderEnabled, @NotNull Function2<? super File, ? super String, Unit> openTraceInPerfettoWebLoader) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(openTraceInPerfettoWebLoader, (String)"openTraceInPerfettoWebLoader");
        this.project = project;
        this.isPerfettoWebLoaderEnabled = isPerfettoWebLoaderEnabled;
        this.openTraceInPerfettoWebLoader = openTraceInPerfettoWebLoader;
    }

    public /* synthetic */ BenchmarkLinkListener(Project project, boolean bl, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = Registry.Companion.is("profiler.trace.open.mode.web", false);
        }
        if ((n & 4) != 0) {
            function2 = (Function2)new Function2<File, String, Unit>((Object)PerfettoTraceWebLoader.INSTANCE){

                public final void invoke(File p0, String p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((PerfettoTraceWebLoader)this.receiver).loadTrace(p0, p1);
                }
            };
        }
        this(project, bl, (Function2<? super File, ? super String, Unit>)function2);
    }

    @Override
    public void hyperlinkClicked(@NotNull String link2) {
        Intrinsics.checkNotNullParameter((Object)link2, (String)"link");
        if (StringsKt.startsWith$default((String)link2, (String)BenchmarkLinkListenerKt.access$getBENCHMARK_TRACE_FILE_PREFIX_V2$p(), (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)link2, (String)BenchmarkLinkListenerKt.access$getBENCHMARK_TRACE_FILE_PREFIX_V3$p(), (boolean)false, (int)2, null)) {
            String link3 = this.convertLinkToV3Format(link2);
            if (!StringsKt.startsWith$default((String)link3, (String)BenchmarkLinkListenerKt.access$getBENCHMARK_TRACE_FILE_PREFIX_V3$p(), (boolean)false, (int)2, null)) {
                throw new IllegalStateException("Check failed.");
            }
            CharSequence charSequence = StringsKt.drop((String)link3, (int)BenchmarkLinkListenerKt.access$getBENCHMARK_TRACE_FILE_PREFIX_V3$p().length());
            Regex regex = new Regex("\\?.*");
            String string = "";
            String fileName = regex.replace(charSequence, string);
            File localFile = new File(FileUtil.getTempDirectory() + File.separator + fileName);
            if (!localFile.exists()) {
                AndroidNotification.getInstance((Project)this.project).showBalloon("Benchmark file not found", "Unable to open trace file (" + localFile.getName() + ")", NotificationType.WARNING);
                return;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(localFile);
            if (virtualFile == null) {
                return;
            }
            VirtualFile virtualFileTrace = virtualFile;
            OpenFileDescriptor fd = new OpenFileDescriptor(this.project, virtualFileTrace);
            if (this.isPerfettoWebLoaderEnabled && this.isUiPerfettoDevSupportedFile(fileName)) {
                Object object = Regex.find$default((Regex)new Regex("\\?(.*)$"), (CharSequence)link3, (int)0, (int)2, null);
                String queryParams = object != null && (object = object.getGroupValues()) != null ? (String)CollectionsKt.getOrNull((List)object, (int)1) : null;
                VirtualFile virtualFile2 = fd.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
                this.openTraceInPerfettoWebLoader.invoke((Object)this.toIoFile(virtualFile2), (Object)queryParams);
            } else {
                List list = FileEditorManager.getInstance((Project)this.project).openEditor(fd, true);
                Intrinsics.checkNotNull((Object)list);
            }
        } else if (StringsKt.startsWith$default((String)link2, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)link2, (String)"https://", (boolean)false, (int)2, null)) {
            BrowserLauncher browserLauncher = BrowserLauncher.Companion.getInstance();
            URI uRI = URI.create(link2);
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
            browserLauncher.browse(uRI);
        }
    }

    private final boolean isUiPerfettoDevSupportedFile(String fileName) {
        return StringsKt.endsWith$default((String)fileName, (String)".perfetto-trace", (boolean)false, (int)2, null);
    }

    private final String convertLinkToV3Format(String link2) {
        Object object;
        if (StringsKt.startsWith$default((String)link2, (String)BenchmarkLinkListenerKt.access$getBENCHMARK_TRACE_FILE_PREFIX_V2$p(), (boolean)false, (int)2, null)) {
            object = BenchmarkLinkListenerKt.access$getBENCHMARK_TRACE_FILE_PREFIX_V3$p() + StringsKt.drop((String)link2, (int)BenchmarkLinkListenerKt.access$getBENCHMARK_TRACE_FILE_PREFIX_V2$p().length());
        } else if (StringsKt.startsWith$default((String)link2, (String)BenchmarkLinkListenerKt.access$getBENCHMARK_TRACE_FILE_PREFIX_V3$p(), (boolean)false, (int)2, null)) {
            object = link2;
        } else {
            throw new IllegalStateException(("Unsupported Benchmark link format: " + link2).toString());
        }
        return object;
    }

    private final File toIoFile(VirtualFile $this$toIoFile) {
        File file = VfsUtil.virtualToIoFile((VirtualFile)$this$toIoFile);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
        return file;
    }
}

