/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.api;

import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultStats;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResults;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCaseResult;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0002\u001a\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0086\u0002\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0007\u001a\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e\u001a\n\u0010\u000f\u001a\u00020\f*\u00020\u0002\u00a8\u0006\u0010"}, d2={"getFullTestCaseName", "", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResults;", "getFullTestClassName", "isRootAggregationResult", "", "plus", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultStats;", "rhs", "getSummaryResult", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCaseResult;", "getRoundedDuration", "Ljava/time/Duration;", "device", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "getRoundedTotalDuration", "intellij.android.testartifacts"})
public final class AndroidTestResultsKt {
    @NotNull
    public static final String getFullTestCaseName(@NotNull AndroidTestResults $this$getFullTestCaseName) {
        Intrinsics.checkNotNullParameter((Object)$this$getFullTestCaseName, (String)"<this>");
        String fullTestClassName = AndroidTestResultsKt.getFullTestClassName($this$getFullTestCaseName);
        if (StringsKt.isBlank((CharSequence)fullTestClassName)) {
            return $this$getFullTestCaseName.getMethodName();
        }
        return fullTestClassName + "." + $this$getFullTestCaseName.getMethodName();
    }

    @NotNull
    public static final String getFullTestClassName(@NotNull AndroidTestResults $this$getFullTestClassName) {
        Intrinsics.checkNotNullParameter((Object)$this$getFullTestClassName, (String)"<this>");
        if (StringsKt.isBlank((CharSequence)$this$getFullTestClassName.getClassName())) {
            return "";
        }
        if (StringsKt.isBlank((CharSequence)$this$getFullTestClassName.getPackageName())) {
            return $this$getFullTestClassName.getClassName();
        }
        return $this$getFullTestClassName.getPackageName() + "." + $this$getFullTestClassName.getClassName();
    }

    public static final boolean isRootAggregationResult(@NotNull AndroidTestResults $this$isRootAggregationResult) {
        Intrinsics.checkNotNullParameter((Object)$this$isRootAggregationResult, (String)"<this>");
        return Intrinsics.areEqual((Object)AndroidTestResultsKt.getFullTestCaseName($this$isRootAggregationResult), (Object)"");
    }

    @NotNull
    public static final AndroidTestResultStats plus(@NotNull AndroidTestResultStats $this$plus, @NotNull AndroidTestResultStats rhs) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        return new AndroidTestResultStats($this$plus.getPassed() + rhs.getPassed(), $this$plus.getFailed() + rhs.getFailed(), $this$plus.getSkipped() + rhs.getSkipped(), $this$plus.getRunning() + rhs.getRunning(), $this$plus.getCancelled() + rhs.getCancelled());
    }

    @NotNull
    public static final AndroidTestCaseResult getSummaryResult(@NotNull AndroidTestResultStats $this$getSummaryResult) {
        Intrinsics.checkNotNullParameter((Object)$this$getSummaryResult, (String)"<this>");
        return $this$getSummaryResult.getFailed() > 0 ? AndroidTestCaseResult.FAILED : ($this$getSummaryResult.getCancelled() > 0 ? AndroidTestCaseResult.CANCELLED : ($this$getSummaryResult.getRunning() > 0 ? AndroidTestCaseResult.IN_PROGRESS : ($this$getSummaryResult.getPassed() > 0 ? AndroidTestCaseResult.PASSED : ($this$getSummaryResult.getSkipped() > 0 ? AndroidTestCaseResult.SKIPPED : AndroidTestCaseResult.SCHEDULED))));
    }

    @Nullable
    public static final Duration getRoundedDuration(@NotNull AndroidTestResults $this$getRoundedDuration, @NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)$this$getRoundedDuration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Duration duration = $this$getRoundedDuration.getDuration(device2);
        if (duration == null) {
            return null;
        }
        Duration duration2 = duration;
        return duration2.compareTo(Duration.ofSeconds(1L)) < 0 ? duration2 : Duration.ofSeconds(duration2.getSeconds());
    }

    @NotNull
    public static final Duration getRoundedTotalDuration(@NotNull AndroidTestResults $this$getRoundedTotalDuration) {
        Duration duration;
        Intrinsics.checkNotNullParameter((Object)$this$getRoundedTotalDuration, (String)"<this>");
        Duration duration2 = $this$getRoundedTotalDuration.getTotalDuration();
        if (duration2.compareTo(Duration.ofSeconds(1L)) < 0) {
            duration = duration2;
        } else {
            Duration duration3 = Duration.ofSeconds(duration2.getSeconds());
            Intrinsics.checkNotNull((Object)duration3);
            duration = duration3;
        }
        return duration;
    }
}

