/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.xr;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.streaming.EmulatorSettings;
import com.android.tools.idea.streaming.xr.XrEnvironment;
import com.android.tools.idea.streaming.xr.XrInputMode;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.Disposable;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\b \u0018\u0000 L2\u00020\u0001:\u0002LMB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010,\u001a\u00020-2\u0006\u0010\f\u001a\u00020\u000bH\u00a6@\u00a2\u0006\u0002\u0010.J \u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u000bH&J\u0010\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u000205H\u0007J\u0010\u00106\u001a\u00020\u00122\u0006\u00104\u001a\u000205H\u0007J \u00107\u001a\u00020\u00122\u0006\u00104\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0007J \u0010=\u001a\u00020\u00122\u0006\u00104\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0007J \u0010>\u001a\u00020\u00122\u0006\u00104\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0007J \u0010?\u001a\u00020\u00122\u0006\u00104\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0007J \u0010@\u001a\u00020\u00122\u0006\u00104\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H'J \u0010A\u001a\u00020\u00122\u0006\u00104\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0007J \u0010B\u001a\u00020\u00122\u0006\u00104\u001a\u00020C2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H'J\u0010\u0010D\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010E\u001a\u00020\u001a2\u0006\u0010F\u001a\u00020\u001aH\u0002J\u0010\u0010G\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0018\u0010H\u001a\u00020-2\u0006\u0010I\u001a\u00020\u001a2\u0006\u0010J\u001a\u00020\u001aH$J\u0006\u0010K\u001a\u00020\u0012R(\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0014@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u001a@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u001a@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001f\u0010\u001dR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006N"}, d2={"Lcom/android/tools/idea/streaming/xr/AbstractXrInputController;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "value", "Lcom/android/tools/idea/streaming/xr/XrEnvironment;", "environment", "getEnvironment", "()Lcom/android/tools/idea/streaming/xr/XrEnvironment;", "setEnvironment", "(Lcom/android/tools/idea/streaming/xr/XrEnvironment;)V", "", "passthroughCoefficient", "getPassthroughCoefficient", "()F", "setPassthroughCoefficient", "(F)V", "isPassthroughSupported", "", "()Z", "Lcom/android/tools/idea/streaming/xr/XrInputMode;", "inputMode", "getInputMode", "()Lcom/android/tools/idea/streaming/xr/XrInputMode;", "setInputMode", "(Lcom/android/tools/idea/streaming/xr/XrInputMode;)V", "", "pressedKeysMask", "setPressedKeysMask", "(I)V", "navigationMask", "setNavigationMask", "mouseDragReferencePoint", "Ljava/awt/Point;", "getMouseDragReferencePoint", "()Ljava/awt/Point;", "setMouseDragReferencePoint", "(Ljava/awt/Point;)V", "emulatorSettings", "Lcom/android/tools/idea/streaming/EmulatorSettings;", "controlKeys", "", "getControlKeys", "()Ljava/lang/String;", "setPassthrough", "", "(FLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendTranslation", "x", "y", "z", "keyPressed", "event", "Ljava/awt/event/KeyEvent;", "keyReleased", "mousePressed", "Ljava/awt/event/MouseEvent;", "deviceDisplaySize", "Ljava/awt/Dimension;", "scaleFactor", "", "mouseReleased", "mouseEntered", "mouseExited", "mouseDragged", "mouseMoved", "mouseWheelMoved", "Ljava/awt/event/MouseWheelEvent;", "areNavigationKeysEnabled", "keyToMask", "keyCode", "pressedKeysMaskToNavigationMask", "sendVelocityUpdate", "newMask", "oldMask", "isMouseUsedForNavigation", "Companion", "NavigationKey", "intellij.android.streaming"})
public abstract class AbstractXrInputController
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile XrEnvironment environment;
    private volatile float passthroughCoefficient = -1.0f;
    @NotNull
    private volatile XrInputMode inputMode = XrInputMode.INTERACTION;
    private int pressedKeysMask;
    private int navigationMask;
    @Nullable
    private Point mouseDragReferencePoint;
    @NotNull
    private final EmulatorSettings emulatorSettings = EmulatorSettings.Companion.getInstance();
    public static final float UNKNOWN_PASSTHROUGH_COEFFICIENT = -1.0f;
    public static final float MOUSE_WHEEL_NAVIGATION_FACTOR = 0.25f;
    public static final float TRANSLATION_SCALE = 4.0f;
    public static final float ROTATION_SCALE = (float)Math.PI;
    public static final float VELOCITY = 1.0f;
    public static final float ANGULAR_VELOCITY = 0.5235988f;

    @Nullable
    public final XrEnvironment getEnvironment() {
        return this.environment;
    }

    public final void setEnvironment(@Nullable XrEnvironment value2) {
        if (value2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.environment != value2) {
            this.environment = value2;
            ActivityTracker.getInstance().inc();
        }
    }

    public final float getPassthroughCoefficient() {
        return this.passthroughCoefficient;
    }

    public final void setPassthroughCoefficient(float value2) {
        if (!(value2 >= 0.0f)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.passthroughCoefficient == value2)) {
            this.passthroughCoefficient = value2;
            ActivityTracker.getInstance().inc();
        }
    }

    public boolean isPassthroughSupported() {
        return true;
    }

    @NotNull
    public final XrInputMode getInputMode() {
        return this.inputMode;
    }

    @UiThread
    public final void setInputMode(@NotNull XrInputMode value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        if (this.inputMode != value2) {
            if (!this.areNavigationKeysEnabled(value2)) {
                this.setPressedKeysMask(0);
                this.mouseDragReferencePoint = null;
            }
            this.inputMode = value2;
        }
    }

    private final void setPressedKeysMask(int value2) {
        if (this.pressedKeysMask != value2) {
            this.pressedKeysMask = value2;
            this.setNavigationMask(this.pressedKeysMaskToNavigationMask(value2));
        }
    }

    private final void setNavigationMask(int value2) {
        if (this.navigationMask != value2) {
            int oldValue = this.navigationMask;
            this.navigationMask = value2;
            this.sendVelocityUpdate(value2, oldValue);
        }
    }

    @Nullable
    protected final Point getMouseDragReferencePoint() {
        return this.mouseDragReferencePoint;
    }

    protected final void setMouseDragReferencePoint(@Nullable Point point) {
        this.mouseDragReferencePoint = point;
    }

    private final String getControlKeys() {
        return this.emulatorSettings.getCameraVelocityControls().getKeys();
    }

    @Nullable
    public abstract Object setPassthrough(float var1, @NotNull Continuation<? super Unit> var2);

    public abstract void sendTranslation(float var1, float var2, float var3);

    @UiThread
    public final boolean keyPressed(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.areNavigationKeysEnabled(this.inputMode)) {
            return false;
        }
        if (event.getModifiersEx() != 0) {
            this.setPressedKeysMask(0);
            return false;
        }
        int mask = this.keyToMask(event.getKeyCode());
        if (mask == 0) {
            return false;
        }
        this.setPressedKeysMask(this.pressedKeysMask | mask);
        event.consume();
        return true;
    }

    @UiThread
    public final boolean keyReleased(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.areNavigationKeysEnabled(this.inputMode)) {
            return false;
        }
        if (event.getModifiersEx() != 0) {
            this.setPressedKeysMask(0);
            return false;
        }
        int mask = this.keyToMask(event.getKeyCode());
        if (mask == 0) {
            return false;
        }
        this.setPressedKeysMask(this.pressedKeysMask & ~mask);
        event.consume();
        return true;
    }

    @UiThread
    public final boolean mousePressed(@NotNull MouseEvent event, @NotNull Dimension deviceDisplaySize, double scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)deviceDisplaySize, (String)"deviceDisplaySize");
        if (!this.isMouseUsedForNavigation()) {
            return false;
        }
        if (event.getButton() == 1) {
            this.mouseDragReferencePoint = event.getPoint();
        }
        event.consume();
        return true;
    }

    @UiThread
    public final boolean mouseReleased(@NotNull MouseEvent event, @NotNull Dimension deviceDisplaySize, double scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)deviceDisplaySize, (String)"deviceDisplaySize");
        if (!this.isMouseUsedForNavigation()) {
            return false;
        }
        if (event.getButton() == 1) {
            this.mouseDragReferencePoint = null;
        }
        event.consume();
        return true;
    }

    @UiThread
    public final boolean mouseEntered(@NotNull MouseEvent event, @NotNull Dimension deviceDisplaySize, double scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)deviceDisplaySize, (String)"deviceDisplaySize");
        if (!this.isMouseUsedForNavigation()) {
            return false;
        }
        if ((event.getModifiersEx() & 0x400) != 0) {
            this.mouseDragReferencePoint = event.getPoint();
        }
        event.consume();
        return true;
    }

    @UiThread
    public final boolean mouseExited(@NotNull MouseEvent event, @NotNull Dimension deviceDisplaySize, double scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)deviceDisplaySize, (String)"deviceDisplaySize");
        return false;
    }

    @UiThread
    public abstract boolean mouseDragged(@NotNull MouseEvent var1, @NotNull Dimension var2, double var3);

    @UiThread
    public final boolean mouseMoved(@NotNull MouseEvent event, @NotNull Dimension deviceDisplaySize, double scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)deviceDisplaySize, (String)"deviceDisplaySize");
        if (!this.isMouseUsedForNavigation()) {
            return false;
        }
        event.consume();
        return true;
    }

    @UiThread
    public abstract boolean mouseWheelMoved(@NotNull MouseWheelEvent var1, @NotNull Dimension var2, double var3);

    private final boolean areNavigationKeysEnabled(XrInputMode inputMode) {
        return switch (WhenMappings.$EnumSwitchMapping$0[inputMode.ordinal()]) {
            case 1, 2, 3 -> true;
            default -> false;
        };
    }

    private final int keyToMask(int keyCode) {
        int index = StringsKt.indexOf$default((CharSequence)this.getControlKeys(), (char)((char)keyCode), (int)0, (boolean)false, (int)6, null);
        if (index >= 0) {
            return 1 << index;
        }
        return switch (keyCode) {
            case 39, 227 -> NavigationKey.ROTATE_RIGHT.getMask();
            case 37, 226 -> NavigationKey.ROTATE_LEFT.getMask();
            case 38, 224 -> NavigationKey.ROTATE_UP.getMask();
            case 40, 225 -> NavigationKey.ROTATE_DOWN.getMask();
            case 33 -> NavigationKey.ROTATE_RIGHT_UP.getMask();
            case 34 -> NavigationKey.ROTATE_RIGHT_DOWN.getMask();
            case 36 -> NavigationKey.ROTATE_LEFT_UP.getMask();
            case 35 -> NavigationKey.ROTATE_LEFT_DOWN.getMask();
            default -> 0;
        };
    }

    private final int pressedKeysMaskToNavigationMask(int pressedKeysMask) {
        int mask = pressedKeysMask & NavigationKey.ROTATE_RIGHT_UP.getMask() - 1;
        if ((pressedKeysMask & NavigationKey.ROTATE_RIGHT_UP.getMask()) != 0) {
            mask = mask | NavigationKey.ROTATE_RIGHT.getMask() | NavigationKey.ROTATE_UP.getMask();
        }
        if ((pressedKeysMask & NavigationKey.ROTATE_RIGHT_DOWN.getMask()) != 0) {
            mask = mask | NavigationKey.ROTATE_RIGHT.getMask() | NavigationKey.ROTATE_DOWN.getMask();
        }
        if ((pressedKeysMask & NavigationKey.ROTATE_LEFT_UP.getMask()) != 0) {
            mask = mask | NavigationKey.ROTATE_LEFT.getMask() | NavigationKey.ROTATE_UP.getMask();
        }
        if ((pressedKeysMask & NavigationKey.ROTATE_LEFT_DOWN.getMask()) != 0) {
            mask = mask | NavigationKey.ROTATE_LEFT.getMask() | NavigationKey.ROTATE_DOWN.getMask();
        }
        int[] nArray = new int[]{NavigationKey.MOVE_RIGHT.getMask() | NavigationKey.MOVE_LEFT.getMask(), NavigationKey.MOVE_UP.getMask() | NavigationKey.MOVE_DOWN.getMask(), NavigationKey.MOVE_BACKWARD.getMask() | NavigationKey.MOVE_FORWARD.getMask(), NavigationKey.ROTATE_RIGHT.getMask() | NavigationKey.ROTATE_LEFT.getMask(), NavigationKey.ROTATE_UP.getMask() | NavigationKey.ROTATE_DOWN.getMask()};
        for (int m : nArray) {
            if ((mask & m) != m) continue;
            mask &= ~m;
        }
        return mask & (NavigationKey.Companion.getTRANSLATION_MASK() | NavigationKey.Companion.getROTATION_MASK());
    }

    protected abstract void sendVelocityUpdate(int var1, int var2);

    public final boolean isMouseUsedForNavigation() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.inputMode.ordinal()]) {
            case 1, 2, 3 -> true;
            default -> false;
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/streaming/xr/AbstractXrInputController$Companion;", "", "<init>", "()V", "UNKNOWN_PASSTHROUGH_COEFFICIENT", "", "MOUSE_WHEEL_NAVIGATION_FACTOR", "TRANSLATION_SCALE", "ROTATION_SCALE", "VELOCITY", "ANGULAR_VELOCITY", "intellij.android.streaming"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0006\b\u0084\u0081\u0002\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/streaming/xr/AbstractXrInputController$NavigationKey;", "", "<init>", "(Ljava/lang/String;I)V", "MOVE_FORWARD", "MOVE_LEFT", "MOVE_BACKWARD", "MOVE_RIGHT", "MOVE_DOWN", "MOVE_UP", "ROTATE_RIGHT", "ROTATE_LEFT", "ROTATE_UP", "ROTATE_DOWN", "ROTATE_RIGHT_UP", "ROTATE_RIGHT_DOWN", "ROTATE_LEFT_UP", "ROTATE_LEFT_DOWN", "mask", "", "getMask", "()I", "cumulativeMask", "getCumulativeMask", "Companion", "intellij.android.streaming"})
    protected static final class NavigationKey
    extends Enum<NavigationKey> {
        @NotNull
        public static final Companion Companion;
        private final int mask = 1 << this.ordinal();
        private static final int TRANSLATION_MASK;
        private static final int ROTATION_MASK;
        public static final /* enum */ NavigationKey MOVE_FORWARD;
        public static final /* enum */ NavigationKey MOVE_LEFT;
        public static final /* enum */ NavigationKey MOVE_BACKWARD;
        public static final /* enum */ NavigationKey MOVE_RIGHT;
        public static final /* enum */ NavigationKey MOVE_DOWN;
        public static final /* enum */ NavigationKey MOVE_UP;
        public static final /* enum */ NavigationKey ROTATE_RIGHT;
        public static final /* enum */ NavigationKey ROTATE_LEFT;
        public static final /* enum */ NavigationKey ROTATE_UP;
        public static final /* enum */ NavigationKey ROTATE_DOWN;
        public static final /* enum */ NavigationKey ROTATE_RIGHT_UP;
        public static final /* enum */ NavigationKey ROTATE_RIGHT_DOWN;
        public static final /* enum */ NavigationKey ROTATE_LEFT_UP;
        public static final /* enum */ NavigationKey ROTATE_LEFT_DOWN;
        private static final /* synthetic */ NavigationKey[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final int getMask() {
            return this.mask;
        }

        public final int getCumulativeMask() {
            return this.mask | this.mask - 1;
        }

        public static NavigationKey[] values() {
            return (NavigationKey[])$VALUES.clone();
        }

        public static NavigationKey valueOf(String value2) {
            return Enum.valueOf(NavigationKey.class, value2);
        }

        @NotNull
        public static EnumEntries<NavigationKey> getEntries() {
            return $ENTRIES;
        }

        static {
            MOVE_FORWARD = new NavigationKey();
            MOVE_LEFT = new NavigationKey();
            MOVE_BACKWARD = new NavigationKey();
            MOVE_RIGHT = new NavigationKey();
            MOVE_DOWN = new NavigationKey();
            MOVE_UP = new NavigationKey();
            ROTATE_RIGHT = new NavigationKey();
            ROTATE_LEFT = new NavigationKey();
            ROTATE_UP = new NavigationKey();
            ROTATE_DOWN = new NavigationKey();
            ROTATE_RIGHT_UP = new NavigationKey();
            ROTATE_RIGHT_DOWN = new NavigationKey();
            ROTATE_LEFT_UP = new NavigationKey();
            ROTATE_LEFT_DOWN = new NavigationKey();
            $VALUES = navigationKeyArray = new NavigationKey[]{NavigationKey.MOVE_FORWARD, NavigationKey.MOVE_LEFT, NavigationKey.MOVE_BACKWARD, NavigationKey.MOVE_RIGHT, NavigationKey.MOVE_DOWN, NavigationKey.MOVE_UP, NavigationKey.ROTATE_RIGHT, NavigationKey.ROTATE_LEFT, NavigationKey.ROTATE_UP, NavigationKey.ROTATE_DOWN, NavigationKey.ROTATE_RIGHT_UP, NavigationKey.ROTATE_RIGHT_DOWN, NavigationKey.ROTATE_LEFT_UP, NavigationKey.ROTATE_LEFT_DOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            TRANSLATION_MASK = MOVE_UP.getCumulativeMask();
            ROTATION_MASK = ROTATE_DOWN.getCumulativeMask() & ~TRANSLATION_MASK;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/streaming/xr/AbstractXrInputController$NavigationKey$Companion;", "", "<init>", "()V", "TRANSLATION_MASK", "", "getTRANSLATION_MASK", "()I", "ROTATION_MASK", "getROTATION_MASK", "intellij.android.streaming"})
        public static final class Companion {
            private Companion() {
            }

            public final int getTRANSLATION_MASK() {
                return TRANSLATION_MASK;
            }

            public final int getROTATION_MASK() {
                return ROTATION_MASK;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[XrInputMode.values().length];
            try {
                nArray[XrInputMode.VIEW_DIRECTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XrInputMode.LOCATION_IN_SPACE_XY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XrInputMode.LOCATION_IN_SPACE_Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

