/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.uisettings.ui;

import com.android.resources.Density;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/streaming/uisettings/ui/GoogleDensityRange;", "", "<init>", "()V", "computeDensityRange", "", "", "screenSize", "Ljava/awt/Dimension;", "physicalDensity", "intellij.android.streaming"})
public final class GoogleDensityRange {
    @NotNull
    public static final GoogleDensityRange INSTANCE = new GoogleDensityRange();

    private GoogleDensityRange() {
    }

    @NotNull
    public final List<Integer> computeDensityRange(@NotNull Dimension screenSize, int physicalDensity) {
        int i;
        float interval;
        Intrinsics.checkNotNullParameter((Object)screenSize, (String)"screenSize");
        int minDimensionPx = Math.min(screenSize.width, screenSize.height);
        int maxDensity = Density.MEDIUM.getDpiValue() * minDimensionPx / 320;
        float maxScaleDimension = 1.5f;
        float maxScale = Math.min(maxScaleDimension, (float)maxDensity / (float)physicalDensity);
        float minScale = 0.85f;
        float minScaleInterval = 0.09f;
        int numLarger = RangesKt.coerceIn((int)((int)((maxScale - 1.0f) / minScaleInterval)), (int)0, (int)3);
        int numSmaller = RangesKt.coerceIn((int)((int)((1.0f - minScale) / minScaleInterval)), (int)0, (int)1);
        List values = new ArrayList();
        if (numSmaller > 0) {
            interval = (1.0f - minScale) / (float)numSmaller;
            for (i = numSmaller; 0 < i; --i) {
                values.add((int)((float)physicalDensity * (1.0f - (float)i * interval)) & 0xFFFFFFFE);
            }
        }
        values.add(physicalDensity);
        if (numLarger > 0) {
            interval = (maxScale - 1.0f) / (float)numLarger;
            i = 1;
            if (i <= numLarger) {
                while (true) {
                    values.add((int)((float)physicalDensity * (1.0f + (float)i * interval)) & 0xFFFFFFFE);
                    if (i == numLarger) break;
                    ++i;
                }
            }
        }
        return values;
    }
}

