/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator.actions;

import com.android.emulator.control.ParameterValue;
import com.android.emulator.control.PhysicalModelValue;
import com.android.tools.idea.streaming.emulator.EmulatorConfiguration;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.streaming.emulator.EmulatorView;
import com.android.tools.idea.streaming.emulator.actions.AbstractEmulatorAction;
import com.android.tools.idea.streaming.emulator.actions.AbstractEmulatorActionKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/streaming/emulator/actions/EmulatorFoldingAction;", "Lcom/android/tools/idea/streaming/emulator/actions/AbstractEmulatorAction;", "posture", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$PostureDescriptor;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$PostureDescriptor;)V", "getPosture", "()Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$PostureDescriptor;", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getPostureValue", "", "postures", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.android.streaming"})
public final class EmulatorFoldingAction
extends AbstractEmulatorAction {
    @NotNull
    private final EmulatorConfiguration.PostureDescriptor posture;

    public EmulatorFoldingAction(@NotNull EmulatorConfiguration.PostureDescriptor posture) {
        Intrinsics.checkNotNullParameter((Object)posture, (String)"posture");
        super(null, 1, null);
        this.posture = posture;
        this.getTemplatePresentation().setText(this.posture.getDisplayName());
        this.getTemplatePresentation().setIcon(this.posture.getIcon());
    }

    @NotNull
    public final EmulatorConfiguration.PostureDescriptor getPosture() {
        return this.posture;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        EmulatorView emulatorView = AbstractEmulatorActionKt.getEmulatorView(event);
        if (emulatorView == null) {
            return;
        }
        EmulatorView emulatorView2 = emulatorView;
        if (!Intrinsics.areEqual((Object)this.posture, (Object)emulatorView2.getCurrentPosture$intellij_android_streaming())) {
            EmulatorController emulator = emulatorView2.getEmulator();
            PhysicalModelValue.PhysicalType type = this.posture.getValueType() == EmulatorConfiguration.PostureDescriptor.ValueType.HINGE_ANGLE ? PhysicalModelValue.PhysicalType.HINGE_ANGLE0 : PhysicalModelValue.PhysicalType.ROLLABLE0;
            PhysicalModelValue.Builder physicalModelValue = PhysicalModelValue.newBuilder().setTarget(type).setValue(ParameterValue.newBuilder().addData((float)this.getPostureValue(this.posture, emulator.getEmulatorConfig().getPostures())));
            PhysicalModelValue physicalModelValue2 = physicalModelValue.build();
            Intrinsics.checkNotNullExpressionValue((Object)physicalModelValue2, (String)"build(...)");
            EmulatorController.setPhysicalModel$default(emulator, physicalModelValue2, null, 2, null);
        }
    }

    private final double getPostureValue(EmulatorConfiguration.PostureDescriptor posture, List<EmulatorConfiguration.PostureDescriptor> postures) {
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        for (EmulatorConfiguration.PostureDescriptor p : postures) {
            if (minValue > p.getMinValue()) {
                minValue = p.getMinValue();
            }
            if (!(maxValue < p.getMaxValue())) continue;
            maxValue = p.getMaxValue();
        }
        return posture.getMinValue() == minValue ? minValue : (posture.getMaxValue() == maxValue ? maxValue : (posture.getMinValue() + posture.getMaxValue()) / (double)2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @NotNull
    public final EmulatorConfiguration.PostureDescriptor component1() {
        return this.posture;
    }

    @NotNull
    public final EmulatorFoldingAction copy(@NotNull EmulatorConfiguration.PostureDescriptor posture) {
        Intrinsics.checkNotNullParameter((Object)posture, (String)"posture");
        return new EmulatorFoldingAction(posture);
    }

    public static /* synthetic */ EmulatorFoldingAction copy$default(EmulatorFoldingAction emulatorFoldingAction, EmulatorConfiguration.PostureDescriptor postureDescriptor, int n, Object object) {
        if ((n & 1) != 0) {
            postureDescriptor = emulatorFoldingAction.posture;
        }
        return emulatorFoldingAction.copy(postureDescriptor);
    }

    @NotNull
    public String toString() {
        return "EmulatorFoldingAction(posture=" + this.posture + ")";
    }

    public int hashCode() {
        return this.posture.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EmulatorFoldingAction)) {
            return false;
        }
        EmulatorFoldingAction emulatorFoldingAction = (EmulatorFoldingAction)((Object)other);
        return Intrinsics.areEqual((Object)this.posture, (Object)emulatorFoldingAction.posture);
    }
}

