/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.google.common.base.Splitter;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0006\u001a$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001\u001a\u001a\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u001a\r\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0002\"\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"readKeyValueFile", "", "", "file", "Ljava/nio/file/Path;", "keysToExtract", "", "updateKeyValueFile", "", "updates", "logError", "message", "e", "Ljava/io/IOException;", "KEY_VALUE_SPLITTER", "Lcom/google/common/base/Splitter;", "kotlin.jvm.PlatformType", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.streaming"})
@JvmName(name="KeyValueFiles")
@SourceDebugExtension(value={"SMAP\nKeyValueFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyValueFileUtils.kt\ncom/android/tools/idea/streaming/emulator/KeyValueFiles\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class KeyValueFiles {
    private static final Splitter KEY_VALUE_SPLITTER = Splitter.on((char)'=').trimResults();

    @NotNull
    public static final Map<String, String> readKeyValueFile(@NotNull Path file, @Nullable Set<String> keysToExtract) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Map result2 = new LinkedHashMap();
        for (String line : Files.readAllLines(file)) {
            List keyValue = KEY_VALUE_SPLITTER.splitToList((CharSequence)line);
            if (keyValue.size() != 2 || keysToExtract != null && !keysToExtract.contains(keyValue.get(0))) continue;
            result2.put(keyValue.get(0), keyValue.get(1));
        }
        return result2;
    }

    public static /* synthetic */ Map readKeyValueFile$default(Path path, Set set2, int n, Object object) {
        if ((n & 2) != 0) {
            set2 = null;
        }
        return KeyValueFiles.readKeyValueFile(path, set2);
    }

    public static final void updateKeyValueFile(@NotNull Path file, @NotNull Map<String, String> updates) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(updates, (String)"updates");
        Map originalContents = KeyValueFiles.readKeyValueFile$default(file, null, 2, null);
        TreeMap<String, String> sortedContents = new TreeMap<String, String>(originalContents);
        sortedContents.putAll(updates);
        Set set2 = sortedContents.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
        List lines = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)set2), KeyValueFiles::updateKeyValueFile$lambda$0), KeyValueFiles::updateKeyValueFile$lambda$1));
        Path tempFile = file.resolveSibling(file.getFileName() + ".temp");
        try {
            Object[] objectArray = new OpenOption[]{StandardOpenOption.CREATE};
            Files.write(tempFile, (Iterable<? extends CharSequence>)lines, Charsets.UTF_8, (OpenOption[])objectArray);
            objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE};
            Files.move(tempFile, file, (CopyOption[])objectArray);
        }
        catch (IOException e) {
            try {
                Files.deleteIfExists(tempFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            KeyValueFiles.logError("Error writing " + file, e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void logError(String message, IOException e) {
        Object object;
        Logger logger;
        block3: {
            block2: {
                void it;
                logger = KeyValueFiles.logger();
                object = e;
                if (object == null || (object = ((Throwable)object).getMessage()) == null) break block2;
                Object object2 = object;
                Logger logger2 = logger;
                boolean bl = false;
                String string = message + " - " + (String)it;
                logger = logger2;
                object = string;
                if (string != null) break block3;
            }
            object = message;
        }
        logger.error((String)object);
    }

    private static final Logger logger() {
        Logger logger = Logger.getInstance((String)"#com.android.tools.idea.streaming.emulator.KeyValueFileUtils");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final boolean updateKeyValueFile$lambda$0(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValue() != null;
    }

    private static final String updateKeyValueFile$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() + "=" + it.getValue();
    }
}

