/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.annotations.concurrency.UiThread;
import com.android.emulator.control.ClipData;
import com.android.ide.common.util.Cancelable;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.protobuf.Empty;
import com.android.tools.idea.streaming.core.AbstractClipboardSynchronizer;
import com.android.tools.idea.streaming.emulator.EmptyStreamObserver;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\b\u0010\u001b\u001a\u00020\u0015H\u0002J\b\u0010\u001c\u001a\u00020\u0015H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0018\u00010\rR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer;", "Lcom/android/tools/idea/streaming/core/AbstractClipboardSynchronizer;", "disposableParent", "Lcom/intellij/openapi/Disposable;", "emulator", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/streaming/emulator/EmulatorController;)V", "getEmulator", "()Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "clipboardFeed", "Lcom/android/ide/common/util/Cancelable;", "clipboardReceiver", "Lcom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer$ClipboardReceiver;", "lock", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "dispose", "", "setDeviceClipboard", "text", "", "forceSend", "", "cancelClipboardFeed", "requestClipboardFeed", "ClipboardReceiver", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nEmulatorClipboardSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorClipboardSynchronizer.kt\ncom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,115:1\n24#2:116\n61#2,5:117\n*S KotlinDebug\n*F\n+ 1 EmulatorClipboardSynchronizer.kt\ncom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer\n*L\n43#1:116\n63#1:117,5\n*E\n"})
public final class EmulatorClipboardSynchronizer
extends AbstractClipboardSynchronizer {
    @NotNull
    private final EmulatorController emulator;
    @Nullable
    private Cancelable clipboardFeed;
    @Nullable
    private ClipboardReceiver clipboardReceiver;
    @NotNull
    private final Object lock;

    public EmulatorClipboardSynchronizer(@NotNull Disposable disposableParent, @NotNull EmulatorController emulator) {
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        Intrinsics.checkNotNullParameter((Object)((Object)emulator), (String)"emulator");
        super(disposableParent);
        this.emulator = emulator;
        this.lock = new Object();
        this.synchronizeDeviceClipboard(true);
    }

    @NotNull
    public final EmulatorController getEmulator() {
        return this.emulator;
    }

    private final Logger getLogger() {
        EmulatorClipboardSynchronizer $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(EmulatorClipboardSynchronizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.cancelClipboardFeed();
            Unit unit = Unit.INSTANCE;
        }
        super.dispose();
    }

    @Override
    @UiThread
    public void setDeviceClipboard(@NotNull String text2, boolean forceSend) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (this.isDisposed()) {
            return;
        }
        if (((CharSequence)text2).length() > 0 && !Intrinsics.areEqual((Object)text2, (Object)this.getLastClipboardText())) {
            this.setLastClipboardText(text2);
            Logger $this$debug_u24default$iv = this.getLogger();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("EmulatorClipboardSynchronizer.setDeviceClipboard: \"" + text2 + "\"", e$iv);
            }
            ClipData clipData = ClipData.newBuilder().setText(text2).build();
            Intrinsics.checkNotNullExpressionValue((Object)clipData, (String)"build(...)");
            this.emulator.setClipboard(clipData, (StreamObserver<Empty>)new EmptyStreamObserver<Empty>(this){
                final /* synthetic */ EmulatorClipboardSynchronizer this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onCompleted() {
                    if (!EmulatorClipboardSynchronizer.access$isDisposed(this.this$0)) {
                        EmulatorClipboardSynchronizer.access$requestClipboardFeed(this.this$0);
                    }
                }
            });
        } else if (this.clipboardFeed == null) {
            this.requestClipboardFeed();
        }
    }

    private final void cancelClipboardFeed() {
        this.clipboardReceiver = null;
        Cancelable cancelable = this.clipboardFeed;
        if (cancelable != null) {
            cancelable.cancel();
        }
        this.clipboardFeed = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void requestClipboardFeed() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.cancelClipboardFeed();
            if (this.emulator.getConnectionState() == EmulatorController.ConnectionState.CONNECTED) {
                ClipboardReceiver receiver2;
                this.clipboardReceiver = receiver2 = new ClipboardReceiver();
                this.clipboardFeed = this.emulator.streamClipboard((StreamObserver<ClipData>)((StreamObserver)receiver2));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ boolean access$isDisposed(EmulatorClipboardSynchronizer $this) {
        return $this.isDisposed();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer$ClipboardReceiver;", "Lcom/android/tools/idea/streaming/emulator/EmptyStreamObserver;", "Lcom/android/emulator/control/ClipData;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer;)V", "onNext", "", "message", "onError", "t", "", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nEmulatorClipboardSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorClipboardSynchronizer.kt\ncom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer$ClipboardReceiver\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,115:1\n61#2,5:116\n*S KotlinDebug\n*F\n+ 1 EmulatorClipboardSynchronizer.kt\ncom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer$ClipboardReceiver\n*L\n98#1:116,5\n*E\n"})
    private final class ClipboardReceiver
    extends EmptyStreamObserver<ClipData> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(@NotNull ClipData message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Logger $this$debug_u24default$iv = EmulatorClipboardSynchronizer.this.getLogger();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("ClipboardReceiver.onNext: \"" + message.getText() + "\"", e$iv);
            }
            Object object = EmulatorClipboardSynchronizer.this.lock;
            EmulatorClipboardSynchronizer emulatorClipboardSynchronizer = EmulatorClipboardSynchronizer.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)emulatorClipboardSynchronizer.clipboardReceiver, (Object)this)) {
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
            String string = message.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() > 0) {
                String string2 = message.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                EmulatorClipboardSynchronizer.this.onDeviceClipboardChanged(string2);
            }
        }

        @Override
        public void onError(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            if (t instanceof EmulatorController.RetryException) {
                EmulatorClipboardSynchronizer.this.requestClipboardFeed();
            }
        }
    }
}

