/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.tools.idea.streaming.device.ControlMessage;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/streaming/device/StartVideoStreamMessage;", "Lcom/android/tools/idea/streaming/device/ControlMessage;", "displayId", "", "maxVideoSize", "Ljava/awt/Dimension;", "<init>", "(ILjava/awt/Dimension;)V", "getDisplayId", "()I", "getMaxVideoSize", "()Ljava/awt/Dimension;", "serialize", "", "stream", "Lcom/android/utils/Base128OutputStream;", "toString", "", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "Companion", "intellij.android.streaming"})
public final class StartVideoStreamMessage
extends ControlMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int displayId;
    @NotNull
    private final Dimension maxVideoSize;
    public static final int TYPE = 6;

    public StartVideoStreamMessage(int displayId, @NotNull Dimension maxVideoSize) {
        Intrinsics.checkNotNullParameter((Object)maxVideoSize, (String)"maxVideoSize");
        super(6, null);
        this.displayId = displayId;
        this.maxVideoSize = maxVideoSize;
    }

    public final int getDisplayId() {
        return this.displayId;
    }

    @NotNull
    public final Dimension getMaxVideoSize() {
        return this.maxVideoSize;
    }

    @Override
    public void serialize(@NotNull Base128OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        super.serialize(stream);
        stream.writeInt(this.displayId);
        stream.writeInt(this.maxVideoSize.width);
        stream.writeInt(this.maxVideoSize.height);
    }

    @Override
    @NotNull
    public String toString() {
        return "StartVideoStreamMessage(displayId=" + this.displayId + ", maxVideoSize=" + this.maxVideoSize.width + "x" + this.maxVideoSize.height + ")";
    }

    public final int component1() {
        return this.displayId;
    }

    @NotNull
    public final Dimension component2() {
        return this.maxVideoSize;
    }

    @NotNull
    public final StartVideoStreamMessage copy(int displayId, @NotNull Dimension maxVideoSize) {
        Intrinsics.checkNotNullParameter((Object)maxVideoSize, (String)"maxVideoSize");
        return new StartVideoStreamMessage(displayId, maxVideoSize);
    }

    public static /* synthetic */ StartVideoStreamMessage copy$default(StartVideoStreamMessage startVideoStreamMessage, int n, Dimension dimension2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = startVideoStreamMessage.displayId;
        }
        if ((n2 & 2) != 0) {
            dimension2 = startVideoStreamMessage.maxVideoSize;
        }
        return startVideoStreamMessage.copy(n, dimension2);
    }

    @Override
    public int hashCode() {
        int result2 = Integer.hashCode(this.displayId);
        result2 = result2 * 31 + this.maxVideoSize.hashCode();
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StartVideoStreamMessage)) {
            return false;
        }
        StartVideoStreamMessage startVideoStreamMessage = (StartVideoStreamMessage)other;
        if (this.displayId != startVideoStreamMessage.displayId) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.maxVideoSize, (Object)startVideoStreamMessage.maxVideoSize);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/streaming/device/StartVideoStreamMessage$Companion;", "Lcom/android/tools/idea/streaming/device/ControlMessage$Deserializer;", "<init>", "()V", "TYPE", "", "deserialize", "Lcom/android/tools/idea/streaming/device/StartVideoStreamMessage;", "stream", "Lcom/android/utils/Base128InputStream;", "intellij.android.streaming"})
    public static final class Companion
    implements ControlMessage.Deserializer {
        private Companion() {
        }

        @Override
        @NotNull
        public StartVideoStreamMessage deserialize(@NotNull Base128InputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            int displayId = stream.readInt();
            int width = stream.readInt();
            int height = stream.readInt();
            return new StartVideoStreamMessage(displayId, new Dimension(width, height));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

