/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.deviceprovisioner.DeviceProperties;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u00a8\u0006\u0007"}, d2={"composeDeviceName", "", "Lcom/android/sdklib/deviceprovisioner/DeviceProperties;", "useTitleAsName", "", "normalizeManufacturerName", "manufacturer", "intellij.android.streaming"})
public final class DeviceConfigurationKt {
    @NotNull
    public static final String composeDeviceName(@Nullable DeviceProperties $this$composeDeviceName, boolean useTitleAsName) {
        String api;
        if ($this$composeDeviceName == null) {
            return "Unknown";
        }
        if (useTitleAsName) {
            return $this$composeDeviceName.getTitle();
        }
        StringBuilder name2 = new StringBuilder();
        String model = $this$composeDeviceName.getModel();
        CharSequence charSequence = model;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String manufacturer;
            CharSequence charSequence2;
            if (!(StringsKt.startsWith$default((String)model, (String)"Pixel", (boolean)false, (int)2, null) || (charSequence2 = (CharSequence)(manufacturer = $this$composeDeviceName.getManufacturer())) == null || StringsKt.isBlank((CharSequence)charSequence2) || Intrinsics.areEqual((Object)manufacturer, (Object)"unknown") || StringsKt.startsWith((String)model, (String)manufacturer, (boolean)true))) {
                name2.append(DeviceConfigurationKt.normalizeManufacturerName(manufacturer)).append(' ');
            }
            v0 = name2.append(StringsKt.startsWith$default((String)model, (String)"Google Pixel", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)model, (CharSequence)"Google ") : model);
        } else {
            v0 = name2.append("unknown");
        }
        AndroidVersion androidVersion = $this$composeDeviceName.getAndroidVersion();
        String string = api = androidVersion != null ? androidVersion.getApiStringWithoutExtension() : null;
        if (api != null) {
            name2.append(" API ").append(api);
        }
        String string2 = name2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public static /* synthetic */ String composeDeviceName$default(DeviceProperties deviceProperties, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return DeviceConfigurationKt.composeDeviceName(deviceProperties, bl);
    }

    private static final String normalizeManufacturerName(String manufacturer) {
        String string;
        if (((CharSequence)manufacturer).length() > 0 && Character.isLowerCase(manufacturer.charAt(0))) {
            String string2 = StringUtil.toTitleCase((String)manufacturer);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toTitleCase(...)");
        } else {
            string = manufacturer;
        }
        return string;
    }
}

