/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import com.android.tools.analytics.UsageTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.DeviceMirroringSession;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\b\u0010\u0017\u001a\u00020\u0015H$R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/streaming/core/StreamingSessionTracker;", "", "<init>", "()V", "deviceInfoProto", "Lcom/google/wireless/android/sdk/stats/DeviceInfo;", "getDeviceInfoProto", "()Lcom/google/wireless/android/sdk/stats/DeviceInfo;", "streamingSessionProto", "Lcom/google/wireless/android/sdk/stats/DeviceMirroringSession;", "getStreamingSessionProto", "()Lcom/google/wireless/android/sdk/stats/DeviceMirroringSession;", "sessionDurationSec", "", "getSessionDurationSec", "()J", "streamingStartTime", "getStreamingStartTime", "setStreamingStartTime", "(J)V", "streamingStarted", "", "streamingEnded", "reset", "intellij.android.streaming"})
public abstract class StreamingSessionTracker {
    private long streamingStartTime;

    @NotNull
    protected abstract DeviceInfo getDeviceInfoProto();

    @NotNull
    protected abstract DeviceMirroringSession getStreamingSessionProto();

    protected final synchronized long getSessionDurationSec() {
        if (!(this.streamingStartTime != 0L)) {
            throw new IllegalStateException("Check failed.");
        }
        return (System.currentTimeMillis() - this.streamingStartTime) / (long)1000;
    }

    protected final long getStreamingStartTime() {
        return this.streamingStartTime;
    }

    protected final void setStreamingStartTime(long l) {
        this.streamingStartTime = l;
    }

    public final synchronized void streamingStarted() {
        if (this.streamingStartTime == 0L) {
            this.reset();
            this.streamingStartTime = System.currentTimeMillis();
        }
    }

    public final synchronized void streamingEnded() {
        if (this.streamingStartTime == 0L) {
            return;
        }
        AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.DEVICE_MIRRORING_SESSION).setDeviceInfo(this.getDeviceInfoProto()).setDeviceMirroringSession(this.getStreamingSessionProto());
        Intrinsics.checkNotNull((Object)studioEvent);
        UsageTracker.log((AndroidStudioEvent.Builder)studioEvent);
        this.streamingStartTime = 0L;
        this.reset();
    }

    protected abstract void reset();
}

